package com.yeejoin.amos.boot.module.jxiop.api.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

@FeignClient(name = "${amos.idx.name:AMOS-IDX}", path = "idx", configuration = {FeignConfiguration.class})
public interface IdxFeign {

    /**
     * 根据风险来源查询人员红黄绿吗信息
     */
    @GetMapping("/jxIopAnalysis/healthIndexData")
    FeignClientResult<Map<String, Object>> healthIndexData(@RequestParam(required = false, value = "parentCode") String parentCode,
                                                           @RequestParam(required = false, value = "stationType") String stationType);

    /**
     * 分页查询业务事实表的数据
     */
    @GetMapping("/table/getPage")
    FeignClientResult<Page<Map<String, Object>>> getPage(@RequestParam Map<String, Object> map);

}
