package com.yeejoin.amos.boot.module.jxiop.biz.controller;


import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.dto.ExcelDto;
import com.yeejoin.amos.boot.module.jxiop.api.Enum.ExcelEnums;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.ExcelServiceImpl;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@RestController
@Api(tags = "导出")
@RequestMapping(value = "/excel")
public class ExcelController extends BaseController {

    @Autowired
    ExcelServiceImpl excelService;

    @Autowired
    RedisUtils redisUtils;



    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "下载模板")
    @GetMapping("/download/template/{type}")
    public void downloadTemplate(HttpServletResponse response, @PathVariable(value = "type") String type, @RequestParam Map par) {
        try {
            ExcelEnums excelEnums = ExcelEnums.getByKey(type);
            ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
                    excelEnums.getClassUrl(), excelEnums.getType());
            excelService.templateExport(response, excelDto,par);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }


    @TycloudOperation(needAuth = false,ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出公用类")
    @GetMapping("/export/{type}")
    public void getFireStationFile(HttpServletResponse response, @PathVariable(value = "type") String type,
                                   @RequestParam Map par) {
        try {
            ExcelEnums excelEnums = ExcelEnums.getByKey(type);
            ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
                    excelEnums.getClassUrl(), excelEnums.getType());
            excelService.commonExport(response, excelDto, par);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导入公用")
    @PostMapping("/upload/{type}")
    public ResponseModel<Object> upload(@RequestPart("file") MultipartFile multipartFile,
                                        @PathVariable(value = "type") String type) {
        try {
            ExcelEnums excelEnums = ExcelEnums.getByKey(type);
            ExcelDto excelDto = new ExcelDto(excelEnums.getFileName(), excelEnums.getSheetName(),
                    excelEnums.getClassUrl(), excelEnums.getType());
            excelService.commonUpload(multipartFile, excelDto);
            return ResponseHelper.buildResponse(null);
        }catch (InnerInvokException e) {
            e.printStackTrace();
            return  this.buildResponseFalse(e.getMessage());
        }  catch (Exception e) {
            e.printStackTrace();
            throw new BadRequest("文件格式不正确或excel 模板不匹配！");
        }

    }

    public  ResponseModel buildResponseFalse(String message) {
        ResponseModel response = new ResponseModel();
        response.setResult(null);
        response.setDevMessage("FAILURE");
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        response.setMessage(message);
        response.setDevMessage(message);
        return response;
    }
}
