package com.yeejoin.precontrol.common.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
/**
 * 惩罚表
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_retribution")
@ApiModel(value="Retribution对象", description="惩罚表")
public class Retribution extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "奖励人id")
    private Long personId;

    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "惩罚金额")
    private BigDecimal money;

    @ApiModelProperty(value = "状态（0-未交罚款，1-已交罚款）")
    private Integer status;

    @ApiModelProperty(value = "交罚款日期")
    private Date exchangeDate;

    @ApiModelProperty(value = "分包商id")
    private Long companyId;
}
