package com.yeejoin.precontrol;

import java.text.ParseException;

import org.eclipse.paho.client.mqttv3.MqttException;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.client.RestTemplate;
import org.typroject.tyboot.component.emq.EmqKeeper;

import com.yeejoin.amos.boot.biz.common.workflow.feign.WorkflowFeignService;
import com.yeejoin.precontrol.common.feign.ExamFeign;
import com.yeejoin.precontrol.common.listener.mqtt.AmosMqTtlListener;
import com.yeejoin.precontrol.common.listener.mqtt.ExamMqTtRecordListener;
import com.yeejoin.precontrol.common.listener.mqtt.ExamMqTtlListener;
import com.yeejoin.precontrol.common.start.StartPlatformTokenService;
import com.yeejoin.precontrol.common.start.StartRiskService;

import lombok.extern.slf4j.Slf4j;

/**
 * @Description: 服务启动类
 * @Author: duanwei
 * @Date: 2020/8/18
 */
@SpringBootApplication
@EnableDiscoveryClient
@EnableFeignClients(basePackages = { "com.yeejoin.precontrol", "org.typroject", "com.yeejoin.amos" })
@EnableEurekaClient
//@EnableWebSocket
@EnableAsync
//@MapperScan({ "com.yeejoin.precontrol.common.mapper", "org.typroject.tyboot.face.*.orm.dao*",
//		"org.typroject.tyboot.core.auth.face.orm.dao", "org.typroject.tyboot.component.*.face.orm.dao*",
//		"com.yeejoin.amos.boot.module.**.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper",
//		"com.yeejoin.amos.boot.module.common.biz.dao" })

//@ComponentScan(basePackages = { "com.yeejoin.precontrol", "com.yeejoin.amos",
//		"org.typroject","com.yeejoin.amos.boot.module.common.api.feign" }, excludeFilters = { @ComponentScan.Filter(type = FilterType.REGEX, pattern = {
//				"com.yeejoin.amos.boot.module.common.biz.service.impl", "com.yeejoin.amos.boot.module.common",
//				"com.yeejoin.amos.boot.biz.common", "com.yeejoin.amos.boot.biz.common.utils",
//				"com.yeejoin.amos.boot.biz.common.service", "com.yeejoin.amos.boot.biz.common.service.impl" }) })
@MapperScan({ "com.yeejoin.precontrol.common.mapper", "org.typroject.tyboot.demo.face.orm.dao*",
		"org.typroject.tyboot.face.*.orm.dao*", "org.typroject.tyboot.core.auth.face.orm.dao*",
		"org.typroject.tyboot.component.*.face.orm.dao*", "com.yeejoin.amos.boot.module.**.api.mapper",
		"com.yeejoin.amos.boot.biz.common.dao.mapper", "com.yeejoin.amos.boot.module.common.biz.dao" })
@ComponentScan(basePackages = { "com.yeejoin.precontrol", "org.typroject", "com.yeejoin.amos",}, excludeFilters = {
				@ComponentScan.Filter(type = FilterType.REGEX, pattern = {}) })
@Slf4j
public class StartPrecontrolService {

	@Autowired
	private EmqKeeper emqKeeper;

	@Autowired
	private AmosMqTtlListener amosMqTtlListener;

	@Autowired
	private ExamMqTtlListener examMqTtlListener;

	@Autowired
	private ExamMqTtRecordListener examMqTtRecordListener;

	@Autowired
	private StartPlatformTokenService startPlatformTokenService;

	@Autowired
	private StartRiskService startRiskService;

	@Autowired
	ExamFeign ExamFeign;

	@Autowired
	WorkflowFeignService WorkflowFeignService;

	public static void main(String[] args) {

		SpringApplication.run(StartPrecontrolService.class, args).getEnvironment();
		log.info("swagger:--->http://localhost:8060/precontrol/swagger-ui.html");
	}

	/**
	 * 使用 websockt注解的时候，使用@EnableScheduling注解后，即开启定时任务 启动的时候一直报错，增加这个bean 则报错解决。
	 * 
	 * @throws ParseException
	 */
	@Bean
	public TaskScheduler taskScheduler() throws ParseException {
		ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
		taskScheduler.setPoolSize(10);
		taskScheduler.initialize();
		return taskScheduler;
	}

	/**
	 * 添加ribbon负载均衡支持
	 */
	@Bean
	@LoadBalanced
	RestTemplate initRestTemplate() {
		return new RestTemplate();
	}

	/**
	 * 初始化MQTT
	 * 
	 * @throws MqttException
	 */
	@Bean
	void initMqtt() throws MqttException {
		emqKeeper.getMqttClient().subscribe("/amos/operation/log", 1, amosMqTtlListener);
		emqKeeper.getMqttClient().subscribe("topic_mqtt_exam", 1, examMqTtlListener);
		emqKeeper.getMqttClient().subscribe("topic_mqtt_exam_record", 1, examMqTtRecordListener);
	}

//    /**
//     * 如果直接使用springboot的内置容器，而不是使用独立的servlet容器，就要注入ServerEndpointExporter，外部容器则不需要。
//     */
//    @Bean
//    public ServerEndpointExporter serverEndpointExporter() {
//        return new ServerEndpointExporter();
//    }

	@Bean
	public void initToken() {
		// startPlatformTokenService.getToken();
	}

	@Bean
	public void initTask() {
		startRiskService.doTimerTask();
	}

}
