package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.yeejoin.amos.boot.biz.common.typeHandler.TypeHandler;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 是否处理器
 */
@Component("yesOrNoTypeHandler")
public class YesOrNoTypeHandler implements TypeHandler<String> {
    private static final Map<String, String> YES_OR_NO_TYPE = new HashMap<>();

    static {
        YES_OR_NO_TYPE.put("1", "是");
        YES_OR_NO_TYPE.put("0", "否");
    }

    @Override
    public String handle(String value) {
        return YES_OR_NO_TYPE.get(value);
    }
}
