package com.yeejoin.amos.api.openapi.face.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

/**
* 特种设备基本信息-维保备案信息Vo
*
* @author duanwei
* @date 2022-07-20
*/
@EqualsAndHashCode(callSuper = true)
@Data
public class MaintenanceInfoModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;


    private List repairInform;


            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码")
    /**
    * 监管系统唯一编码
    */
    private String superviseCode;
            @ApiModelProperty(value = "维保单位统一社会信用代码")
    /**
    * 维保单位统一社会信用代码
    */
    private String meUnitCreditCode;
            @ApiModelProperty(value = "维保单位名称")
    /**
    * 维保单位名称
    */
    private String meUnitName;
            @ApiModelProperty(value = "维保合同备案ID")
    /**
    * 维保合同备案ID
    */
    private String repairInformId;
            @ApiModelProperty(value = "维保合同开始日期")
    /**
    * 维保合同开始日期
    */
    private Date informStart;
            @ApiModelProperty(value = "维保合同结束日期")
    /**
    * 维保合同结束日期
    */
    private Date informEnd;
            @ApiModelProperty(value = "维保负责人姓名")
    /**
    * 维保负责人姓名
    */
    private String meMaster;
            @ApiModelProperty(value = "维保负责人身份证号")
    /**
    * 维保负责人身份证号
    */
    private String meMasterId;
            @ApiModelProperty(value = "紧急救援电话")
    /**
    * 紧急救援电话
    */
    private String emergencycall;
            @ApiModelProperty(value = "维保周期(单位：月)")
    /**
    * 维保周期(单位：月)
    */
    private Integer meCycle;
            @ApiModelProperty(value = "大修周期(单位：月)")
    /**
    * 大修周期(单位：月)
    */
    private Integer overhaulCycle;
            @ApiModelProperty(value = "24小时维保电话")
    /**
    * 24小时维保电话
    */
    private String me24Telephone;



}
