package com.yeejoin.amos.api.openapi.face.orm.entity;

import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 特种设备基本信息-监督管理信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_supervise_info")
@ApiModel(value="TmJgSuperviseInfo对象", description="特种设备基本信息-监督管理信息")
public class SuperviseInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备唯一标识码")

    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "管辖分局组织机构代码")
    private String orgBranchCode;

    @ApiModelProperty(value = "管辖分局名称")
    private String orgBranchName;

    @ApiModelProperty(value = "是否重点监察设备(是、否)")
    private String keyMonitoringEqu;

    @ApiModelProperty(value = "是否在人口密集区(是、否)")
    private String denselyPopulatedAreas;

    @ApiModelProperty(value = "是否在重要场所(是、否)")
    private String importantPlaces;


}
