package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author DELL
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_organization_user")
@ApiModel(value="OrganizationUser对象", description="组织机构应急小组成员")
public class OrganizationUser extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "应急小组名称")
    private String emergencyTeamName;

    @ApiModelProperty(value = "应急小组id")
    private String emergencyTeamId;

    @ApiModelProperty(value = "岗位名称")
    private String postName;

    @ApiModelProperty(value = "电话")
    private String telephone;

    @ApiModelProperty(value = "头像地址")
    private String headPhoto;

    @ApiModelProperty(value = "成员姓名")
    private String memberName;

    @ApiModelProperty(value = "成员id")
    private String memberNameId;

    @ApiModelProperty(value = "会商码")
    private String consultationNub;


}
