package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.entity.Firefighters;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrganizationExportDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrganizationUserExportDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Organization;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


public interface OrganizationMapper extends BaseMapper<Organization> {


    Page<Map<String, Object>> getOrganizationInfo(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode);

    Page<Map<String, Object>> getOrganizationList(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode);

    Page<Map<String, Object>> getOrganizationGroup(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode);

    List<OrganizationExportDto> selectOrganization(@Param("bizOrgCode") String bizOrgCode);

    List<OrganizationUserExportDto> selectOrganizationUserList(@Param("bizOrgCode") String bizOrgCode);

    int selectMaxSort();


}
