package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsrAgencyUser;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrAgencyUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 部门信息修改
 *
 * @author tb
 * @date 2021-06-18
 */
@RestController
@Api(tags = "人员amos账号信息Api")
@RequestMapping(value = "/org-usr-agency")
public class OrgUsrAgencyUserController extends BaseController {

    @Autowired
    IOrgUsrAgencyUserService orgUsrAgencyUserService;

    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;

    /**
     * 查询关联的amos账号信息
     *
     * @return OrgUsrAgencyUser
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{orgUsrId}/detail", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "查询关联的amos账号信息", notes = "查询关联的amos账号信息")
    public ResponseModel<OrgUsrAgencyUser> getAccountDetail(@PathVariable String orgUsrId) {
        OrgUsrAgencyUser orgUsrAgencyUser = new OrgUsrAgencyUser();
        OrgUsrAgencyUser agencyUser = orgUsrAgencyUserService.getAccountDetail(orgUsrId);
        if (ObjectUtils.isEmpty(agencyUser)) {
            orgUsrAgencyUser.setUpAmosUser("0");
            return ResponseHelper.buildResponse(orgUsrAgencyUser);
        }
        if (!StringUtils.isEmpty(agencyUser.getGroupIds())) {
            List<String> list1 = Arrays.asList(agencyUser.getGroupIds().split(","));
            QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("type", list1);
            queryWrapper.eq("code", "CB_USER_GROUP");
            List<DataDictionary> list = iDataDictionaryService.list(queryWrapper);
            orgUsrAgencyUser.setDataDictionaryList(list);
            List<String> collect = list.stream().map(DataDictionary::getCode).collect(Collectors.toList());
            orgUsrAgencyUser.setGroupIdsCode(collect);
        }
        return ResponseHelper.buildResponse(agencyUser);
    }
}