package com.yeejoin.amos;

import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@Configuration
@EnableWebSecurity

public class WebSecurityConfig extends WebSecurityConfigurerAdapter {
    // 授权
    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable()
                .headers()
                .frameOptions()
                .disable()
                .and()
                .authorizeRequests()
                .regexMatchers("^(?!/actuator).*$").permitAll()
                .regexMatchers("/actuator/health").permitAll()
                .regexMatchers("/actuator/info").permitAll()
                .anyRequest().authenticated().and()
                .formLogin();
    }
}
