package com.yeejoin.amos.boot.module.tdc.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

@Data

@Accessors(chain = true)
@TableName("tdc_check_result")
@ApiModel(value="CheckResult对象", description="检验结果表")
public class CheckResult {
    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @ApiModelProperty(value="模型Id")
    private String modelId;

    @ApiModelProperty(value="检查项")
    private String checkItem;

    @ApiModelProperty(value="检查项名称")
    private String checkItemLabel;

    @ApiModelProperty(value="检查项值")
    private String checkItemValue;

    @ApiModelProperty(value="检查项结果")
    private String checkItemResult;

    @ApiModelProperty(value="校验时间")
    private Date checkDate;

    @ApiModelProperty(value="批次号")
    private String batchNo;

    @ApiModelProperty(value="检查结果说明")
    private String checkExplain;

    @ApiModelProperty(value="校验类型")
    private Integer checkType;

    @ApiModelProperty(value="模型所属机构")
    private String amosOrgCode;

    @ApiModelProperty(value="模型所属机构名称")
    private String amosOrgName;

    @ApiModelProperty(value="模型名称")
    private String modelName;


}
