package com.yeejoin.amos.latentdanger.common.enums;

/**
 * 隐患执行状态
 *
 * @author DELL
 */
public enum LatentDangerProcessStateEnum {

    /**
     * 未审核
     */
    未审核("未审核", "0"),
    /**
     * 待审核
     */
    待审核("待审核", "1"),
    /**
     * 待整改
     */
    待整改("待整改", "2"),
    /**
     * 待复核
     */
    待复核("待复核", "3"),
    /**
     * 治理完毕
     */
    治理完毕("治理完毕", "4");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    LatentDangerProcessStateEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static String getEnumName(String code) {
        String name = "";
        for(LatentDangerProcessStateEnum type: LatentDangerProcessStateEnum.values()) {
            if (type.getCode()==code) {
                name = type.getName();
                break;
            }
        }
        return name;
    }

    public static LatentDangerProcessStateEnum getByCode(String code) {
        for (LatentDangerProcessStateEnum l : LatentDangerProcessStateEnum.values()) {
            if (l.getCode().equals(code)) {
                return l;
            }
        }
        return null;
    }
}
