package com.yeejoin.amos.boot.module.jg.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author system_generator
 * @date 2023-12-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgEnableDisableDto", description = "")
public class JgEnableDisableDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "申请日期")
    private Date applyDate;

    @ApiModelProperty(value = "办理状态")
    private String auditStatus;

    @ApiModelProperty(value = "接受机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "接受机构代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "接受机构公司代码")
    private String receiveCompanyCode;

    @ApiModelProperty(value = "终审通过时间")
    private Date auditPassDate;

    @ApiModelProperty(value = "备注（申请说明）")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date createDate;

    @ApiModelProperty(value = "申请日期，接收查询参数")
    private String applicationDate;

    @ApiModelProperty("设备品种")
    private String equDefine;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备代码")
    private String equCode;

    @ApiModelProperty(value = "96333识别码")
    private String code96333;

    @ApiModelProperty(value = "设备地址")
    private String address;

    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecutorIds;

    @ApiModelProperty(value = "任务发起人id")
    private String promoter;

    @ApiModelProperty(value = "申请类型（1启用，0停用）")
    private String applyType;


    private List<String> roleIds;

    private String type;

    @ApiModelProperty(value = "工作流下一节点任务id")
    private String nextTaskId;

    @ApiModelProperty(value = "其他附件")
    private String otherAccessories;

    @ApiModelProperty(value = "设备种类code")
    private String equListCode;

    @ApiModelProperty(value = "设备种类name")
    private String equListName;

    @ApiModelProperty(value = "使用登记证id，多个逗号分割")
    private String registrationManageId;

    @ApiModelProperty(value = "使用登记证编号，多个逗号分割（冗余前端检索使用）")
    private String useRegistrationCode;
}
