package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 安全追溯-索道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("9000")
public class RopewayTechParamDefine implements ITechParamDefine {

    @TechnicalParameter(key = "horizontalDistance", label = "平距", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "m")
    private BigDecimal horizontalDistance;


    @TechnicalParameter(key = "supportsCount", label = "支架数目", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "座")
    private BigDecimal supportsCount;


    @TechnicalParameter(key = "obliqueLength", label = "斜长", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "m")
    private BigDecimal obliqueLength;


    @TechnicalParameter(key = "mainMotorModel", label = "主电机型式", type = TechnicalParameter.ParamType.STRING)
    private String mainMotorModel;


    @TechnicalParameter(key = "mainMotorPower", label = "主电机功率", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "W")
    private BigDecimal mainMotorPower;


    @TechnicalParameter(key = "altitudeDifference", label = "高差", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "m")
    private BigDecimal altitudeDifference;


    @TechnicalParameter(key = "freightVolume", label = "运量", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "p/h")
    private BigDecimal freightVolume;

    @TechnicalParameter(key = "carrierLine", label = "运载索", type = TechnicalParameter.ParamType.STRING, dictCode = "YZS")
    private String carrierLine;


    @TechnicalParameter(key = "speed", label = "速度", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "m/s")
    private BigDecimal speed;

    @TechnicalParameter(key = "bearingCable", label = "承载索", type = TechnicalParameter.ParamType.STRING)
    private String bearingCable;


    @TechnicalParameter(key = "cablePitch", label = "索距", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "m")
    private BigDecimal cablePitch;


    @TechnicalParameter(key = "oilPressureHeavyHammer", label = "张紧油压（重锤重量）", type = TechnicalParameter.ParamType.BIG_DECIMAL,unit = "MPa")
    private BigDecimal oilPressureHeavyHammer;


    @TechnicalParameter(key = "numberAndTypeOfVehicles", label = "运载工具数量和类型", type = TechnicalParameter.ParamType.STRING)
    private String numberAndTypeOfVehicles;

}
