package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.Getter;

@Getter
public enum SpeRegionInfoEnum {

    GX(610131, "高新区", "50*52*96"),
    JK(610132, "经开区", "50*52*97"),
    XX(617000, "西咸新区", "50*18667");

    /**
     * 行政区划code
     */
    private final Integer code;

    /**
     * 名称
     */


    private final String name;

    /**
     * 描述
     */
    private final String orgCode;

    SpeRegionInfoEnum(Integer code, String name, String orgCode) {
        this.code = code;
        this.name = name;
        this.orgCode = orgCode;
    }

    public static SpeRegionInfoEnum getByCode(Integer code) {
        for (SpeRegionInfoEnum e : SpeRegionInfoEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
}
