package com.yeejoin.amos.boot.module.common.api.feign;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.common.api.dto.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.component.feign.config.InnerInvokException;

/**
 * 装备服务feign
 *
 * @author Dell
 */
@FeignClient(name = "${equip.fegin.name:AMOS-EQUIPMENT}", path = "equip", configuration = {MultipartSupportConfig.class})
public interface EquipFeignClient {

    /**
     * 获取未列装人员装备列表数据
     *
     * @return
     */
    @RequestMapping(value = "/equipSpecific/getAirEquipSpecificPage", method = RequestMethod.POST)
    ResponseModel<Page<Object>> getAirEquipSpecificPage(@RequestBody Object var1) throws InnerInvokException;

    /**
     * 人员装备列装
     *
     * @return
     */
    @RequestMapping(value = "/stock-detail/airport/person/bind", method = RequestMethod.POST)
    ResponseModel<List<Object>> stockBindEquip(@RequestBody List<Long> ids) throws InnerInvokException;

    /**
     * 人员装备退装
     *
     * @return
     */
    @RequestMapping(value = "/scrap/airport/person", method = RequestMethod.POST)
    ResponseModel<Object> scrapEquip(@RequestBody String id) throws InnerInvokException;

    /**
     * 人员装备回库
     *
     * @return
     */
    @RequestMapping(value = "/stock-detail/airport/person", method = RequestMethod.POST)
    ResponseModel<Object> stockEquip(@RequestBody Map<String, Object> map) throws InnerInvokException;

    /**
     * 装备详情
     *
     * @return
     */
    @RequestMapping(value = "/equipSpecific/getAirEquipSpecificDetail", method = RequestMethod.GET)
    ResponseModel<Object> getAirEquipSpecificDetail(@RequestParam("stockDetailId") Long stockDetailId) throws InnerInvokException;

    /**
     * 获取车辆列表
     *
     * @return
     */
    @RequestMapping(value = "/car/list-all", method = RequestMethod.GET)
    ResponseModel<Object> getFireCarListAll();




    /**
     * 获取本单位下车辆列表
     *
     * @return
     */
    @RequestMapping(value = "/car/list-allpag", method = RequestMethod.GET)
    ResponseModel<Page<CarInfoDto>> equipmentCarList(@RequestParam("teamId") Long teamId,
                                                     @RequestParam("name") String name,
                                                     @RequestParam("code") String code ,
                                                     @RequestParam("pageNum") String pageNum,
                                                     @RequestParam("pageSize") String pageSize,
                                                     @RequestParam("id") Long id,
                                                     @RequestParam("isNo") Boolean isNo );




    /**
     * 车辆树
     **/
    @RequestMapping(value = "/equipment-category/tree/2", method = RequestMethod.GET)
    ResponseModel<Object> gettree();




    /**
     * 根据id查询车辆车载水量及泡沫量
     *
     * @param carIds
     * @return
     */
    @RequestMapping(value = "/car/peoperty", method = RequestMethod.POST)
    ResponseModel<Map<String,Object>> getCarPropertyByCarIds(@RequestBody List<Long> carIds);

    /**
     * 获取个队伍下车辆统计
     *
     * @return
     */
    @RequestMapping(value = "/car/list-info", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> getFireCarListAllcount();

    /**
     * 获取消防系统列表
     *
     * @return
     */
    @RequestMapping(value = "/fire-fighting-system/list", method = RequestMethod.GET)
    ResponseModel<Object> getFireSystemListAll();

    /**
     * 获取消防系统列表
     *
     * @return
     */
    @RequestMapping(value = "/building/tree", method = RequestMethod.GET)
    ResponseModel<Object> getBuildingTree();
    /**
     * 获取消防建筑详情
     *
     * @return
     */
    @RequestMapping(value = "/building/getOne", method = RequestMethod.GET)
    ResponseModel<Object> getOne(@RequestParam("instanceId") Long instanceId);
    /**
     * 获取指定建筑的经纬度信息
     *
     * @return
     */
    @RequestMapping(value = "/building/getBuildingToLongitudeAndLatitude", method = RequestMethod.GET)
    ResponseModel<Object> getBuildingToLongitudeAndLatitude(@RequestParam("instanceId") String instanceId);
    /**
     * 更新车辆状态
     *
     * @param carStatusInfo 车辆状态信息
     * @return
     */
    @RequestMapping(value = "/car/status", method = RequestMethod.POST)
    ResponseModel<Object> updateCarStatus(@RequestBody List<Object> carStatusInfo);

    /**
     * 获取装备平面图
     *
     * @return
     */
    @RequestMapping(value = "/sourceFile/findImgByFileCategory", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> findImgByFileCategory(@RequestParam("id") String id, @RequestParam("fileCategory") String fileCategory);

    /**
     * 车辆信息
     **/
    @RequestMapping(value = "/car/getTeamCarList", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> getTeamCarList(@RequestParam("sequenceNbr") String sequenceNbr,@RequestParam("longitude") Double longitude, @RequestParam("latitude") Double latitude);
    
    
    /**
     * 车辆信息详情
     **/
    @RequestMapping(value = "/car/getCarDetailById/{id}", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getCarDetailById(@PathVariable("id") Long id);

    /**
     * 获取消防建筑树
     *
     * @return
     */
    @RequestMapping(value = "/building/BuildingtreeAndEquip", method = RequestMethod.GET)
    ResponseModel<Object> getBuildingTreeAndEquip();


    /**
     *
     *获取视频信息
     * @param
     * @return
     */
    @RequestMapping(value = "/building/video/page", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> getVideo( @RequestParam("current") long current,
                                                       @RequestParam("size") long size,
                                                       @RequestParam("buildingId") Long buildingId);

    @RequestMapping(value = "/building/video/page", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> getVideopag( @RequestParam("current") String current,
                                                          @RequestParam("size") String size,
                                                          @RequestParam("buildingId") String buildingId,
                                                          @RequestParam("code") String code,
                                                          @RequestParam("equipmentName") String equipmentName,
                                                          @RequestParam("bizOrgCode") String bizOrgCode,
                                                          @RequestParam("type") String type
    );


    @RequestMapping(value = "/monitorView/video/page", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> queryVideoPage(
                                            @RequestParam(value = "nodeId") Long nodeId,
                                            @RequestParam(value = "nodeType" ,required =false) String nodeType,
                                            @RequestParam(value = "current") int current,
                                            @RequestParam(value = "size") int size
    );


    @RequestMapping(value = "/confirmAlarm/getDetailsById", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>>  getDetailsById(@RequestParam Long alamId,
                                                       @RequestParam(required = false) Long equipId,
                                                       @RequestParam(required = false) String type,
                                                       @RequestParam(required = false) String area) ;
    /**
     *
     *获取视频列表
     * @param
     * @return
     */
    @RequestMapping(value = "/video/pageVideo", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> pageVideo(@RequestParam("pageNum") Integer pageNum,
                                                       @RequestParam("pageSize") Integer pageSize,
                                                       @RequestParam("longitude") Double longitude,
                                                       @RequestParam("latitude") Double latitude,
                                                       @RequestParam("distance") Double distance);

    @RequestMapping(value = "/video/pageVideoByAlertType", method = RequestMethod.POST)
    ResponseModel<Page<Map<String, Object>>> pageVideoByAlertType(@RequestParam("pageNum") Integer pageNum,
                                                       @RequestParam("pageSize") Integer pageSize,
                                                                  @RequestBody RequestData par);


    @RequestMapping(value = "/video/pageList", method = RequestMethod.GET)
    ResponseModel<Page<VideoDto>> pageList(@RequestParam("current") Integer current,
                                           @RequestParam("size") Integer size,
                                           @RequestParam("code") String code,
                                           @RequestParam("name") String name,
                                           @RequestParam("typeCode") String typeCode);

    @RequestMapping(value = "/building/video/page", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> getVideoList( @RequestParam(value = "viewId") Long viewId,
                                                       @RequestParam(value = "videoName" ,required =false) String videoName,
                                                       @RequestParam(value = "videoCode" ,required =false) String videoCode,
                                                       @RequestParam(value = "current") int current,
                                                       @RequestParam(value = "size") int size);

    @RequestMapping(value = "/building/video/pageList", method = RequestMethod.POST)
    ResponseModel<Page<Map<String, Object>>> getVideopagList( @RequestParam("current") String current,
                                                              @RequestParam("size") String size,
                                                              @RequestParam(value = "buildingId",required = false) String buildingId,
                                                              @RequestParam(value = "code",required = false) String code,
                                                              @RequestParam(value = "equipmentName",required = false) String equipmentName,
                                                              @RequestParam(value = "bizOrgCode",required = false) String bizOrgCode,
                                                              @RequestParam(value = "type",required = false) String type
    );


    /**
     *
     *获取视频列表
     * @param
     * @return
     */
    @RequestMapping(value = "/video/getByid", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getByid( @RequestParam("id") Long id);

    /**
     *
     *获取车辆简要信息
     * @param id 消防车id
     * @return
     */
    @RequestMapping(value = "/car/simple/{id}", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> queryCarSimpleInfoById(@PathVariable("id") Long id);

    /**
     * 统计
     **/
    @RequestMapping(value = "/equipSpecificAlarm/getCountAlarm/{type}", method = RequestMethod.GET)
    ResponseModel<Integer> getCountAlarm(@PathVariable("type") String type);

    /**
     * 统计
     **/
    @RequestMapping(value = "/equipSpecificAlarm/getcountAlarmHandle/{type}", method = RequestMethod.GET)
    ResponseModel<Integer> getcountAlarmHandle(@PathVariable("type") String type);

    /**
     * 获取装备全路径
     *
     * @return Map<String, Object>
     **/
    @RequestMapping(value = "/building/getBuildingAbsolutePosition", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getBuildingAbsolutePosition();

    /**
     * 根据实例id 获取实例信息 // 需求 958 新增值班区域 值班区域id 字段 获取名称 by kongfm 2021-09-15
     *
     * @return
     */
    @RequestMapping(value = "/building/getFormInstanceById", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getFormInstanceById(@RequestParam("instanceId") Long instanceId);

    /**
     * 查询所有建筑的数据字典 // 需求 958 新增值班区域 值班区域id 字段  获取下拉列表 by kongfm 2021-09-15
     * @return
     */
    @RequestMapping(value = "/building/getAllBuilding", method = RequestMethod.GET)
    ResponseModel<List<LinkedHashMap<String, Object>>> getAllBuilding();

    /**
     * 查询所有建筑的数据字典// BUG 2935 优化项 分类从93060000 取得字典数据 by kongfm 2021-09-17
     * @return
     */
    @RequestMapping(value = "equipment-category/tree/{type}", method = RequestMethod.GET)
    ResponseModel<List<LinkedHashMap<String, Object>>> getEquipmentCategory(@PathVariable("type") String type);

    @RequestMapping(value = "/equipment/listLike/{code}", method = RequestMethod.GET)
    ResponseModel<List<LinkedHashMap<String, Object>>> listLikePage(@PathVariable("code") String code);

    /**
     * 未处理消防告警 by litw 2021年10月25日
     *
     * @return
     */
    @RequestMapping(value = "/confirmAlarm/getFireAlarm", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getFireAlarm();

    /**
     * 未处理消防告警 by litw 2021年10月25日
     *
     * @return
     */
    @RequestMapping(value = "/confirmAlarm/getFaultAlarm", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getFaultAlarm();

    /**
     * 未处理消防告警 by litw 2021年10月25日
     *
     * @return
     */
    @RequestMapping(value = "/confirmAlarm/getMonitorEvent", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getMonitorEvent();

    /**
     * 装备定义性能参数列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/perf-quota/listAll", method = RequestMethod.POST)
    ResponseModel<List<EquipmentIndexDto>> getEquipmentIndexDto(@RequestBody PerfQuotaIotDTO perfQuotaIotDTO);

    
    @RequestMapping(value = "/car/{id}", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> selectOneById( @PathVariable("id") Long id);


    @RequestMapping(value = "/car/getCarDetailByCarNum/{carNum}", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getCarDetailByCarNum( @PathVariable("carNum") String carNum);


    @RequestMapping(value = "/car/all/fusion", method = RequestMethod.GET)
    ResponseModel<List> getCarFusionList();


    @RequestMapping(value = "/equipment/query/classification/", method = RequestMethod.GET)
    ResponseModel<List> getClassification();


    @RequestMapping(value = "/equipment/list/{typeCode}", method = RequestMethod.GET)
    ResponseModel<List> getEquipmentList(@PathVariable("typeCode") String typeCode);
    
    @RequestMapping(value = "equipment-category/list-tree", method = RequestMethod.GET)
    ResponseModel<Object>   list() ;

    //获取消防装备权限
    @RequestMapping(value = "/equipment-detail/permissions/export", method = RequestMethod.GET)
    ResponseModel<ReginParams>  getPermissions() ;
    
    @RequestMapping(value = "/building/getBuildingList", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>>  getBuildingTreeList();
    
    @RequestMapping(value = "/building/companyBuildingTree", method = RequestMethod.GET)
    public  ResponseModel<Object> getCompanyBuildingTree();


    @RequestMapping(value = "/building/tree", method = RequestMethod.GET)
    LinkedHashMap<String,Object> getTreeBuilding();

    /**
     * 根据code获取指定分类的装备列表
     * @param code 分类
     * @return 装备列表
     */
    @RequestMapping(value = "equipSpecific/getListByEquipmentCode/{code}", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>>  getListByEquipmentCode(@PathVariable("code") String code);
    /**
     * 根据code获取指定分类的装备列表
     * @param code 分类
     * @return 装备列表
     */
    @RequestMapping(value = "equipSpecific/getListByEquipmentCodeEQ/{code}", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>>  getListByEquipmentCodeEQ(@PathVariable("code") String code);
}
