package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import com.yeejoin.amos.boot.biz.common.workflow.feign.WorkflowFeignService;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.enums.OrgPersonEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.DynamicFormInstanceMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.controller.DataDictionaryController;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.interceptors.PermissionInterceptorContext;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.common.api.core.framework.PersonIdentify;
import com.yeejoin.amos.boot.module.common.api.entity.CompanyInfo;
import com.yeejoin.amos.boot.module.common.api.entity.FireTeam;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.common.api.mapper.FireTeamMapper;
import com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrMapper;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.ESOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FireCompanyInfoServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 部门信息修改
 *
 * @author tb
 * @date 2021-06-18
 */
@RestController
@Api(tags = "单位Api")
@RequestMapping(value = "/org-usr")
public class OrgUsrController extends BaseController {

	@Autowired
	DataDictionaryServiceImpl iDataDictionaryService;

	@Autowired
	OrgUsrServiceImpl iOrgUsrService;

	@Autowired
	private IOrgUsrService orgUsrService;

	@Autowired
	ESOrgUsrService eSOrgUsrService;

	@Autowired
	FireTeamMapper fireTeamMapper;

	@Autowired
	OrgUsrMapper orgUsrMapper;

	@Autowired
	FireCompanyInfoServiceImpl fireCompanyInfoServiceImpl;

	@Autowired
	EmqKeeper emqKeeper;
	@Value("${jcs.company.topic.delete:jcs/company/topic/delete}")
	private String airportDeleteTopic;

	@Autowired
	EquipFeignClient equipFeignClient;
	@Autowired
	WorkflowFeignService workflowFeignService;

	@Autowired
	DataDictionaryController dataDictionaryController;
	@Value("special-dept")
	String deptKey;
	@Value("special-deptType")
	String deptTypeKey;

	@Autowired
	DynamicFormInstanceMapper dynamicFormInstanceMapper;

	private static final String AUTH_SPECIAL_KEY = "fire_build_video_info";
	/**
	 * 新增单位信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增单位信息", notes = "新增单位信息")
	public ResponseModel<Object> saveOrgUsr(HttpServletRequest request, @RequestBody OrgUsrDto orgUsrDto)
			throws Exception {
		orgUsrDto.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_COMPANY);
		return ResponseHelper.buildResponse(iOrgUsrService.saveOrgUsr(orgUsrDto));
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public ResponseModel<String> deleteById(HttpServletRequest request, @PathVariable Long id) {

		QueryWrapper<CompanyInfo> queryWrapper = new QueryWrapper<>();
		CompanyInfo info = fireCompanyInfoServiceImpl.getOne(queryWrapper.eq("instance_id", id).eq("is_delete", 0));
		if (!ValidationUtil.isEmpty(info)) {
			info.setIsDelete(true);
		}
		fireCompanyInfoServiceImpl.updateById(info);
		// 删除时，只作逻辑删除
		// BUG 2741 首先判断是否为公司 如果公司底下有人员不可直接删除 bykongfm
		// bug 2882 判断是否为部门 如果部门底下有人员不可直接删除 chenzhao 2021-09-27 start
		OrgUsr tempOrg = iOrgUsrService.getById(id.toString());
		// 当前登录人不能删除自己
		AgencyUserModel user = getUserInfo();

		if (tempOrg.getAmosOrgId() != null && tempOrg.getAmosOrgId().equals(user.getUserId())) {

			return ResponseHelper.buildResponse("-1");
		}

		if (tempOrg.getBizOrgType().equals("COMPANY") || tempOrg.getBizOrgType().equals("DEPARTMENT")) {
			List<OrgUsr> tempList = iOrgUsrService
					.list(new LambdaQueryWrapper<OrgUsr>().eq(OrgUsr::getParentId, id).eq(OrgUsr::getIsDelete, false));
			/* bug3031 删除机场单位后，队伍所属单位字段数据未清空 2021-10-13 start */
			List<FireTeam> fireTeams = fireTeamMapper.byTeamId(id);
			if (tempList.size() > 0 || fireTeams.size() > 0) {
				return ResponseHelper.buildResponse("-1");
			}
			/* bug3031 删除机场单位后，队伍所属单位字段数据未清空 2021-10-13 end */
		}
		// bug 2882 判断是否为部门 如果部门底下有人员不可直接删除 chenzhao 2021-09-27 end
//        iOrgUsrService.update(new UpdateWrapper<OrgUsr>().eq("sequence_nbr", id).set("is_delete", CommonConstant.IS_DELETE_01));
		/* bug 2812 一次删除多条数据 传入类型修改为string 问题解决 2021-09-09 陈召 开始 */
		iOrgUsrService.update(new UpdateWrapper<OrgUsr>().eq("sequence_nbr", String.valueOf(id)).set("is_delete",
				CommonConstant.IS_DELETE_01));
		/* bug 2812 一次删除多条数据 传入类型修改为string 问题解决 2021-09-09 陈召 结束 */
		try {
			eSOrgUsrService.deleteById(id);
//			emqKeeper.getMqttClient().publish(airportDeleteTopic, JSON.toJSONString(id).getBytes(), 2, false);
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException();
		}
		return ResponseHelper.buildResponse("0");
	}




	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getUserTelephone", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取人员详情", notes = "获取人员详情")
	public ResponseModel<Map<String,Object>> getUserTelephone(HttpServletRequest request, @RequestParam Long boss) throws Exception {

		Map<String,Object> telephone=new HashMap<>();
		OrgUsr org=iOrgUsrService.selectByAmosOrgId(boss);
		if(org!=null){
			QueryWrapper<DynamicFormInstance> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("field_code", "telephone");
			queryWrapper.eq("instance_id", org.getSequenceNbr());
			DynamicFormInstance dynamicFormInstance = dynamicFormInstanceMapper.selectOne(queryWrapper);
			if(dynamicFormInstance!=null){
				telephone.put("telephone",dynamicFormInstance.getFieldValue());
			}else{
				telephone.put("telephone","");
			}
		}
		return ResponseHelper.buildResponse(telephone);
	}


	/**
	 * 更新单位数据
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "更新单位数据", notes = "更新单位数据")
	public ResponseModel<?> updateByIdOrgUsr(HttpServletRequest request, @RequestBody OrgUsrDto OrgUsrVo,
			@PathVariable Long id) throws Exception {
		OrgUsrVo.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_COMPANY);
//        iOrgUsrService.updateByIdOrgUsr(OrgUsrVo, id);
		return ResponseHelper.buildResponse(iOrgUsrService.updateByIdOrgUsr(OrgUsrVo, id));
	}

	/**
	 * 根据id查询单位
	 *
	 * @param id
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getUnit/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位详情", notes = "获取单位详情")
	public ResponseModel<OrgUsrFormDto> selectById(HttpServletRequest request, @PathVariable Long id) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.selectCompanyById(id));
	}

	/**
	 * 根据单位code查询单位
	 *
	 * @param code
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getUnitByCode/{code}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位详情", notes = "获取单位详情")
	public ResponseModel<OrgUsrFormDto> selectByCode(HttpServletRequest request, @PathVariable String code) throws Exception {
		LambdaQueryWrapper<OrgUsr> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(OrgUsr::getCode, code);
		OrgUsr orgUsr = iOrgUsrService.getBaseMapper().selectOne(queryWrapper);
		return ResponseHelper.buildResponse(iOrgUsrService.selectCompanyById(orgUsr.getSequenceNbr()));
	}

	/**
	 * 根据bizOrgType分页查询
	 *
	 * @param bizOrgType
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/selectByBizOrgType/{bizOrgType}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据bizOrgType分页查询", notes = "根据bizOrgType分页查询")
	public ResponseModel<IPage<OrgUsr>> bizOrgTypeListPage(String pageNum, String pageSize,
			@PathVariable String bizOrgType) throws Exception {
		return ResponseHelper
				.buildResponse(iOrgUsrService.page(iOrgUsrService.bizOrgTypeListPage(pageNum, pageSize, bizOrgType)));
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTree", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位部门树(key为物理主键)", notes = "获取单位部门树(key为物理主键)\"")
	public ResponseModel<List<OrgMenuDto>> selectCompanyTree() throws Exception {
		List<OrgMenuDto> menus = iOrgUsrService.getCompanyTree(null, iOrgUsrService.selectCompanyDepartmentMsg(),
				OrgUsr.class.getName(), "getSequenceNbr", 2, "getBizOrgName",
				"getParentId", "getBizOrgType", "getBizOrgCode");
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/orgTree", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位部门树(bizOrgCode为物理主键)", notes = "获取单位部门树(bizOrgCode为物理主键)\"")
	public ResponseModel<List<OrgMenuDto>> selectCompanyTreeCode() throws Exception {
		List<OrgMenuDto> menus = OrgUsrServiceImpl.buildTreeParallel(iOrgUsrService.selectCompanyDepartmentMsg());
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/org/company/tree", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位树(bizOrgCode为物理主键)", notes = "获取单位树(bizOrgCode为物理主键)")
	public ResponseModel<List<OrgMenuDto>> getCompanyTree() {
		List<OrgMenuDto> menus = OrgUsrServiceImpl.buildTreeParallel(iOrgUsrService.selectCompanyList());
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<OrgUsr> listPage(String pageNum, String pageSize, OrgUsr orgUsr) {
		Page<OrgUsr> pageBean;
		QueryWrapper<OrgUsr> orgUsrQueryWrapper = new QueryWrapper<>();
		Class<? extends OrgUsr> aClass = orgUsr.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(orgUsr);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		orgUsrQueryWrapper.eq("is_delete", 0);
		IPage<OrgUsr> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iOrgUsrService.page(pageBean, orgUsrQueryWrapper);
		return page;
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/new-list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "新列表分页查询---只查询当前登录人本单位下的对应数据信息", notes = "新列表分页查询---只查询当前登录人本单位下的对应数据信息")
	public IPage<OrgUsr> newlistPage(String pageNum, String pageSize, OrgUsr orgUsr) {
		ReginParams reginParams = getSelectedOrgInfo();
		String companyIdString = reginParams.getPersonIdentity().getCompanyId();
		orgUsr.setParentId(companyIdString);
		Page<OrgUsr> pageBean;
		QueryWrapper<OrgUsr> orgUsrQueryWrapper = new QueryWrapper<>();
		Class<? extends OrgUsr> aClass = orgUsr.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(orgUsr);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		orgUsrQueryWrapper.eq("is_delete", 0);
		IPage<OrgUsr> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iOrgUsrService.page(pageBean, orgUsrQueryWrapper);
		return page;
	}

	/**
	 * 导入部门信息
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/saveDepartment", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "导入部门信息", notes = "导入部门信息")
	public ResponseModel<?> saveDepartment(HttpServletRequest request,
			@RequestBody List<OrgDepartmentDto> OrgDepartmentVo, @PathVariable Long id) throws Exception {
		iOrgUsrService.saveDepartment(OrgDepartmentVo, id);
		return ResponseHelper.buildResponse(null);
	}

	/**
	 * 导入单位信息
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/saveCompany", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "导入单位信息", notes = "导入单位信息")
	public ResponseModel<?> saveCompany(HttpServletRequest request, @RequestBody List<OrgUsrDto> OrgUsrVo)
			throws Exception {
		iOrgUsrService.saveCompany(OrgUsrVo);
		return ResponseHelper.buildResponse(null);
	}

	/**
	 * 根据id获取单位人员列表
	 *
	 * @param ids
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{ids}/users", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id获取单位人员列表", notes = "根据id获取单位人员列表")
	public ResponseModel<List<Map<String, Object>>> selectUsersByOrgCode(HttpServletRequest request,
			@PathVariable List<Long> ids) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.returnCompanyPersonMsg(ids));
	}

	/**
	 * 根据id获取单位人员列表
	 *
	 * @param ids
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/company/{ids}/person", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id获取单位人员列表", notes = "根据id获取单位人员列表")
	public ResponseModel<List<CompanyPerson>> selectCompanyPerson(@PathVariable List<Long> ids) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.returnCompanyPerson(ids));
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/company/person/{amosUserId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据amosUserId获取单位ID", notes = "根据amosUserId获取单位ID")
	public ResponseModel<String> selectPersonId(@PathVariable String amosUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getParentId(amosUserId));
	}

	/**
	 * 根据id获取单位人员列表
	 *
	 * @param amosUserId
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/company/{amosUserId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据amos userid获取单位", notes = "根据amos userid获取单位")
	public ResponseModel<OrgUsrDto> selectCompany(@PathVariable String amosUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getOrg(amosUserId));
	}

	/**
	 * 获取当前登陆人所在机场单位人员
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/company/users/{orgUnitId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据amos userid获取单位", notes = "根据amos userid获取单位")
	public ResponseModel<List<OrgUsr>> selectCompanyUsers(@PathVariable Long orgUnitId) throws Exception {

		return ResponseHelper.buildResponse(iOrgUsrService.selectCompanyUsers(orgUnitId));
	}

	/**
	 * 根据名称模糊匹配
	 *
	 * @param name
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getdataList/unit", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据名称模糊匹配单位", notes = "根据名称模糊匹配单位")
	public ResponseModel<Set<ESOrgUsrDto>> selectByIddata(HttpServletRequest request, String name) throws Exception {
		return ResponseHelper.buildResponse(eSOrgUsrService.queryByKeys(name));
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeByUser", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登陆人获取单位部门树", notes = "根据登陆人获取单位部门树")
	public ResponseModel<List<OrgMenuDto>> selectCompanyTreeByUser() throws Exception {
		// 获取登陆人角色
		AgencyUserModel user = getUserInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUser(user);
		return ResponseHelper.buildResponse(menus);
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeByUserAndType", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登录人及类型获取公司部门树", notes = "根据登录人及类型获取公司部门树")
	public ResponseModel<List<OrgMenuDto>> companyTreeByUserAndType() {
		// 获取登陆人角色
		ReginParams reginParams = getSelectedOrgInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUserNumber(reginParams);
		return ResponseHelper.buildResponse(menus);
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeByUserToPatrolRoute", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登录人获取公司部门树【部门账号登录可查看上级单位】", notes = "根据登录人获取公司部门树")
	public ResponseModel<List<OrgMenuDto>> companyTreeByUserToPatrolRoute() {
		// 获取登陆人角色
		ReginParams reginParams = getSelectedOrgInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUserToPatrolRoute(reginParams);
		return ResponseHelper.buildResponse(menus);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeByUserAndTypeToPartol", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登录人及类型获取公司部门树", notes = "根据登录人及类型获取公司部门树")
	public ResponseModel<List<OrgMenuDto>> companyTreeByUserAndTypeToPartol() {
		// 获取登陆人角色
		ReginParams reginParams = getSelectedOrgInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUserNumberNew(reginParams);
		return ResponseHelper.buildResponse(menus);
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeByUserCurrent", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登录人获取当前公司部门树", notes = "根据登录人获取当前公司部门树")
	public ResponseModel<List<OrgMenuDto>> companyTreeByUser() {
		// 获取登陆人角色
		ReginParams reginParams = getSelectedOrgInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUser(reginParams);
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyUserTreeByUser", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登陆人获取单位部门用户树", notes = "根据登陆人获取单位部门用户树")
	public ResponseModel<List<OrgMenuDto>> companyUserTreeByUser() {
		// 获取登陆人角色
		AgencyUserModel user = getUserInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyUserTreeByUser(user);
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取单位列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyListByUser", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登陆人获取单位列表", notes = "根据登陆人获取单位列表")
	public ResponseModel<List<CheckObjectDto>> companyListByUser() {
		String bizOrgCodeString=	getOrgCode();
		// 获取登陆人角色
		AgencyUserModel user = getUserInfo();
		List<CheckObjectDto> menus = iOrgUsrService.companyListByUser(user,bizOrgCodeString);
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取用户单位归属
	 *
	 * @param userId
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{userId}/userUnit", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取用户单位归属", notes = "获取用户单位归属")
	public ResponseModel<UserUnitDto> getUserUnit(@PathVariable String userId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getUserUnit(userId));
	}

	/**
	 * 获取用户信息
	 *
	 * @param userId
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{userId}/userInfo", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取用户信息", notes = "获取用户信息")
	public ResponseModel<List<UserDto>> getUserInfo(@PathVariable String userId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getUserInfo(userId));
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{userId}/getUserParentInfo", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取用户本级及父级信息", notes = "获取用户本级及父级信息")
	public UserDto getUserParentInfo(@PathVariable String userId) {
		return orgUsrService.getUserParentInfo(userId);
	}

	/**
	 * 获取登陆人绑定的人员关系
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = { "/getLoginUserDetails/{userId}", "/getLoginUserDetails" }, method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取登陆人绑定的人员关系", notes = "获取登陆人绑定的人员关系")
	public ResponseModel<List<Map<String, Object>>> getLoginUserDetails(@PathVariable(required = false) String userId) {
		AgencyUserModel user = getUserInfo();
		String userIds = userId;
		if (StringUtils.isEmpty(userIds)) {
			userIds = user.getUserId();
		}
		List<Map<String, Object>> loginUserDetails = iOrgUsrService.getLoginUserDetails(userIds, user);
		return ResponseHelper.buildResponse(loginUserDetails);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getParentBuilding/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取最上级station", notes = "获取最上级建筑信息")
	public ResponseModel<JSONObject> getBuliding(@PathVariable Long id) {
		JSONObject equipjSONObject = this.getBulid(id);
		return ResponseHelper.buildResponse(equipjSONObject);
	}

	public JSONObject getBulid(Long id) {
		ResponseModel<Object> equipObj = equipFeignClient.getOne(id);
		JSONObject equipjSONObject = JSONObject.parseObject(JSONObject.toJSONString(equipObj.getResult()));
		if (!equipjSONObject.containsKey("parentId")) {
			return null;
		}
		if (!"0".equals(equipjSONObject.getString("parentId"))) {
			String parentId = equipjSONObject.getString("parentId");
			if (StringUtils.isNotBlank(parentId)) {
				return getBulid(Long.parseLong(parentId));
			}
		}
		return equipjSONObject;
	}

	/**
	 * 判断关联账户是否已关联
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getAmosId/{amosId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "判断关联账户是否已关联", notes = "判断关联账户是否已关联")
	public ResponseModel<Object> getAmosId(@PathVariable String amosId,
										   @RequestParam(required = false) String orgUsrId) {
		return ResponseHelper.buildResponse(iOrgUsrService.amosIdExist(amosId, orgUsrId));
	}

	/**
	 * 判断关联账户是否已关联-队伍
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getAmosIdTeam/{amosId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "判断关联账户是否已关联", notes = "判断关联账户是否已关联")
	public ResponseModel<Object> getAmosIdTeam(@PathVariable String amosId) {
		return ResponseHelper.buildResponse(iOrgUsrService.amosIdExistTeam(amosId));
	}

	/**
	 * 根据机场人员id获取amos平台人员id
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场人员id获取amos平台人员信息", notes = "根据机场人员id获取amos平台人员信息")
	@GetMapping(value = "/amos/{orgUserId}")
	public ResponseModel<AgencyUserModel> getAmosIdByOrgUserId(@PathVariable String orgUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getAmosIdByOrgUserId(orgUserId));
	}

	/**
	 * 根据机场人员id(逗号分割)获取amos平台人员id列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场人员id(逗号分割)获取amos平台人员id列表", notes = "根据机场人员id(逗号分割)获取amos平台人员id列表")
	@GetMapping(value = "/amos/orgUserIds")
	public ResponseModel<List<String>> getAmosIdListByOrgUserId(@RequestParam String orgUserIds) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getAmosIdListByOrgUserId(orgUserIds));
	}

	/**
	 * 根据单位id列表或未同步的机场单位列表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/unSync/orgCompany")
	@ApiOperation(httpMethod = "GET", value = "将所有机场单位数据同步到消防监督服务p_point表", notes = "将所有机场单位数据同步到消防监督服务p_point表")
	public ResponseModel getUnSyncOrgCompanyList(@RequestParam List<Long> companyIdList) {
		return ResponseHelper.buildResponse(iOrgUsrService.getUnSyncOrgCompanyList(companyIdList));
	}

	/**
	 * 根据机场单位id获取各单位下部门数量
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场单位id获取各单位下部门数量", notes = "根据机场单位id获取各单位下部门数量")
	@GetMapping(value = "/amos/companyIds")
	public ResponseModel<Map<String, Integer>> getDeptCountByCompanyIds(@RequestParam List<String> companyIdList)
			throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getDeptCountByCompanyIds(companyIdList));
	}

	/**
	 * 根据机场人员ids获取amos平台人员列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场人员ids获取amos平台人员列表", notes = "根据机场人员ids获取amos平台人员列表")
	@GetMapping(value = "/amos/list/{orgUserId}")
	public ResponseModel<List<AgencyUserModel>> getAmosUserByOrgUser(@PathVariable String orgUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getAmosUserByOrgUser(orgUserId));
	}

	/**
	 * 根据机场单位id获取单位人员列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场单位id获取单位人员列表", notes = "根据机场单位id获取单位人员列表")
	@GetMapping(value = "/{companyId}/person/list")
	public ResponseModel<List<OrgUsr>> getPersonListByCompanyId(@PathVariable String companyId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getPersonListByCompanyId(companyId));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场单位id获取单位人员列表", notes = "根据机场单位id获取单位人员列表")
	@GetMapping(value = "/{companyId}/person/listNew")
	public ResponseModel<List<OrgUsr>> getPersonListByCompanyIdnew(@PathVariable String companyId) {
		List<OrgUsr> lit=iOrgUsrService.getPersonListByCompanyId(companyId);
		for (OrgUsr orgUsr : lit) {
			orgUsr.setAmosOrgId(orgUsr.getAmosOrgId()+"@"+orgUsr.getParentId());
		}
		return ResponseHelper.buildResponse(lit);
	}

	/**
	 * 根据机场单位id获取单位人员列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "当前角色为单位防火监督检查负责人 --下的-- 根据机场单位id获取单位人员列表", notes = "当前角色为单位防火监督检查负责人 --下的--根据机场单位id获取单位人员列表")
	@GetMapping(value = "/{companyId}/person/newList")
	public ResponseModel<List<OrgUsr>> getNewPersonListByCompanyId(@PathVariable String companyId) {
		ReginParams reginParams = getSelectedOrgInfo();
		String roleNameString = reginParams.getUserModel().getOrgNames();
		String currentCompanyId = getCompanyId(reginParams);
	//	if (companyId.equals(currentCompanyId) && roleNameString.contains("Person_charge_unit_fire_protection_supervision_inspection")) {//单位防火监督检查负责人
		if ( roleNameString.contains("Person_charge_unit_fire_protection_supervision_inspection")) {//单位防火监督检查负责人
			return ResponseHelper.buildResponse(iOrgUsrService.getPersonListByCompanyId(companyId));
		}
		return null;
	}

	/**
	 * 根据id获取单位人员列表
	 *
	 * @param amosUserId
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getOrgUser/byAmosUserId", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据amos userid模糊匹配获取对应机场单位人员信息列表", notes = "根据amos userid模糊匹配获取对应机场单位人员信息列表")
	public ResponseModel<Object> getOrgUserByAmosUserId(@RequestParam String amosUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getOrgUserByAmosUserId(amosUserId));
	}

	/**
	 * 根据机构类型和登陆人bizOrgCode获取列表不分页
	 *
	 * @param orgTypes 机构类型（逗号分割）
	 * @return list不分页
	 */
	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机构类型(逗号分割),机构编码获取列表不分页", notes = "根据机构类型(逗号分割),机构编码获取列表不分页")
	@GetMapping(value = "/amos/getListByBizOrgTypesCode")
	public ResponseModel<List<OrgUsr>> getListByBizOrgTypeCode(@RequestParam(required = false) String orgTypes) {
		ReginParams reginParams = getSelectedOrgInfo();
		ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
		String bizOrgCode = personIdentity.getBizOrgCode();
		return ResponseHelper.buildResponse(iOrgUsrService.getListByBizOrgTypeCode(orgTypes, bizOrgCode));
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机构类型(逗号分割),机构编码获取列表不分页", notes = "根据机构类型(逗号分割),机构编码获取列表不分页")
	@GetMapping(value = "/{authKey}/listWithAuth")
	public ResponseModel<List<OrgUsr>> getListWithAuth(@RequestParam(required = false) String orgTypes,
													   @RequestParam(required = false) String type,
			@PathVariable String authKey) throws Exception {
		ReginParams reginParams = getSelectedOrgInfo();
		ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
		String bizOrgCode = personIdentity.getBizOrgCode();
		if ("dl".equals(type)){
			LambdaQueryWrapper<OrgUsr> lambda = new QueryWrapper<OrgUsr>().lambda();
			lambda.eq(OrgUsr::getBizOrgCode, bizOrgCode);
			lambda.eq(OrgUsr::getIsDelete, false);
			OrgUsr orgUsr = orgUsrMapper.selectList(lambda).get(0);
			if (!org.apache.commons.lang3.ObjectUtils.isEmpty(orgUsr.getBizOrgType()) && "COMPANY".equals(orgUsr.getBizOrgType())) {
				bizOrgCode = orgUsr.getBizOrgCode();
			} else {
				bizOrgCode = getCompanyNameById(orgUsr.getParentId());
			}
		}

		//拿到数据字典中存储的 特殊类型 特殊部门
		QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("type", "SpecialType").or().eq("type", "SpecialDepartment");
		Collection<DataDictionary> list = iDataDictionaryService.list(queryWrapper);
		List<String> objects = new ArrayList<>();
		List<DataDictionary> specialDepartment = list.stream().filter(e -> e.getType().equals("SpecialDepartment")).collect(Collectors.toList());

		for (DataDictionary dataDictionary : specialDepartment) {
			LambdaQueryWrapper<OrgUsr> wrapper = new LambdaQueryWrapper<>();
			wrapper.eq(OrgUsr::getParentId,dataDictionary.getCode());
			wrapper.eq(BaseEntity::getIsDelete,false);
			List<OrgUsr> orgUsrs = orgUsrMapper.selectList(wrapper);
			orgUsrs.forEach(e->objects.add(e.getSequenceNbr().toString()));
		}

		list.forEach(e->objects.add(e.getCode()));
		//判断当前登录人权限是否处于特殊类型
		if (objects.contains(authKey) || AUTH_SPECIAL_KEY.equals(authKey)){
			//判断当前登录人部门是否处于特殊部门
			if (objects.contains(personIdentity.getCompanyId()) || AUTH_SPECIAL_KEY.equals(authKey)) {
				//查询当前登录人所属单位/部门
				OrgUsr orgUsr = orgUsrMapper.selectById(personIdentity.getCompanyId());
				//判断登陆人是否已经是顶级节点单位
				if (!ObjectUtils.isEmpty(orgUsr) && orgUsr.getParentId() != null) {
					orgUsr = orgUsrService.selectParentOrgUsr(orgUsr);
					bizOrgCode = orgUsr.getBizOrgCode() != null? orgUsr.getBizOrgCode() : personIdentity.getBizOrgCode();
				}
			}
		}
		// 权限处理
		PermissionInterceptorContext.setDataAuthRule(authKey);
		return ResponseHelper.buildResponse(iOrgUsrService.getListByBizOrgTypeCode(orgTypes, bizOrgCode));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getParentId", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "查当前登录人的所属单位", notes = "查当前登录人的所属单位")
	public ResponseModel<String> getParentId() {
		ReginParams reginParams = getSelectedOrgInfo();

		ResponseModel<Object> companyByUserId = this.getCompanyByUserId(Long.valueOf(reginParams.getUserModel().getUserId()));
		Object result = companyByUserId.getResult();
		String s = JSONObject.toJSONString(result);
		OrgUsr orgUsr = JSONObject.parseObject(s, OrgUsr.class);
		String companyId = String.valueOf(orgUsr.getSequenceNbr());
		//判断登陆人是否已经是顶级节点单位
		if (orgUsr.getParentId() != null ) {
			orgUsr  =orgUsrService.selectParentOrgUsr(orgUsr);
			companyId = String.valueOf(orgUsr.getSequenceNbr());
		}
		return ResponseHelper.buildResponse(companyId);
	}




	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{authKey}/treeWithAuth", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据权限查询公司部门树", notes = "根据权限查询公司部门树")
	public ResponseModel<List<OrgMenuDto>> getCompanyTreeWithAuth(@RequestParam(required = false) String orgType,
			@PathVariable String authKey) {
		// 获取登陆人角色
		ReginParams reginParams = getSelectedOrgInfo();

		if(authKey.equals("fire_building_info")){
			if (StringUtils.isNotEmpty(orgType) && orgType.equals("COMPANY")){
				//查询当前登录人所属单位/部门
				OrgUsr orgUsr = orgUsrMapper.selectById(reginParams.getPersonIdentity().getCompanyId());
				//判断登陆人是否已经是顶级节点单位
				if (orgUsr.getParentId() != null ){
					orgUsr  =iOrgUsrService.selectParentOrgUsr(orgUsr);
					String	bizOrgCode = orgUsr.getBizOrgCode() != null? orgUsr.getBizOrgCode() : reginParams.getPersonIdentity().getBizOrgCode();
					ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
					personIdentity.setBizOrgCode(bizOrgCode);
					reginParams.setPersonIdentity(personIdentity);
				}
			}
		}
		// 权限处理
		PermissionInterceptorContext.setDataAuthRule(authKey);
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUserAndType(reginParams, orgType, null);
		return ResponseHelper.buildResponse(menus);
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeAll", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "全量公司部门树", notes = "全量公司部门树")
	public ResponseModel<List<OrgMenuDto>> companyTreeAll(@RequestParam(required = false) String orgType) {
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeAll(orgType);
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 查询多个组织机构下面的所有人员列表信息
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询多个组织机构下面的所有人员列表信息", notes = "查询多个组织机构下面的所有人员列表信息")
	@GetMapping(value = "/company/person/list")
	public ResponseModel<List<OrgUsr>> getPersonListByCompanyIdList(@RequestParam String companyIds) {
		List<OrgUsr> orgUserList = Lists.newArrayList();
		if (!ValidationUtil.isEmpty(companyIds)) {
			List<String> companyIdList = Lists.newArrayList(companyIds.split(","));
			orgUserList = iOrgUsrService.getPersonListByCompanyIdList(companyIdList);
		}
		return ResponseHelper.buildResponse(orgUserList);
	}

	/**
	 * 查询多个组织机构下面的所有人员列表信息
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询上级单位", notes = "查询上级单位")
	@GetMapping(value = "/company/bizOrgCode/list")
	public ResponseModel<OrgUsrDto> getCompanyByBizOrgCodeList(@RequestParam String bizOrgCode) {
		if (ValidationUtil.isEmpty(bizOrgCode)) {
			return ResponseHelper.buildResponse(new OrgUsrDto());
		}
		return ResponseHelper.buildResponse(iOrgUsrService.getCompanyByBizOrgCodeList(bizOrgCode));
	}

	/**
	 * 查询多个组织机构下面的所有人员列表信息
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询当前人员所属的第一级公司", notes = "查询当前人员所属的第一级公司")
	@GetMapping(value = "find/getCompanyByUserId")
	public ResponseModel<Object> getCompanyByUserId(@RequestParam Long userId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getCompanyByUserId(userId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询当前人员的身份证号码", notes = "查询当前人员的身份证号码")
	@GetMapping(value = "find/getIdNumberByAmosId")
	public ResponseModel<String> getIdNumberByAmosId(@RequestParam String amosId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getIdNumberByAmosId(amosId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据平台Id查询人员", notes = "根据平台Id查询人员")
	@GetMapping(value = "find/getByAmosId")
	public ResponseModel<List<OrgUsr>> getByAmosId(@RequestParam List<String> amosIds) {
		return ResponseHelper.buildResponse(iOrgUsrService.getByAmosId(amosIds));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据bizOrgCode查询公司部门 非树", notes = "根据bizOrgCode查询公司部门 非树")
	@GetMapping(value = "find/getByOrgCode")
	public ResponseModel<Object> getByOrgCode(@RequestParam String bizOrgCode) {
		return ResponseHelper.buildResponse(iOrgUsrService.getByOrgCode(bizOrgCode));
	}




	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "无权限单位树", notes = "无权限单位树")
	@GetMapping(value = "/listCompanyTree")
	public ResponseModel<List<OrgUsr>> listCompanyTree(@RequestParam(required = false) String orgType) throws Exception {
		ReginParams reginParams = getSelectedOrgInfo();
		ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
		String bizOrgCode = personIdentity.getBizOrgCode();

		List<OrgUsr> listByBizOrgTypeCode = iOrgUsrService.getListByBizOrgTypeCode(orgType, bizOrgCode);
		return ResponseHelper.buildResponse(listByBizOrgTypeCode);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据amosId返回单位code", notes = "根据amosId返回单位code")
	@GetMapping(value = "/getBizByAmos")
	public ResponseModel<String> getBizByAmos() throws Exception {
		ReginParams selectedOrgInfo = getSelectedOrgInfo();
		String userId = selectedOrgInfo.getUserModel().getUserId();
		String parentId = iOrgUsrService.getParentId(userId);
		OrgUsr orgUsr = iOrgUsrService.getById(parentId);
		return ResponseHelper.buildResponse(orgUsr.getBizOrgCode());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询公司bizOrgCode", notes = "查询公司bizOrgCode")
	@GetMapping(value = "/getCompany")
	public ResponseModel<String> getBizByAmos(@RequestParam("bizOrgCode") String bizOrgCode) {
		LambdaQueryWrapper<OrgUsr> lambda = new QueryWrapper<OrgUsr>().lambda();
		lambda.eq(OrgUsr::getBizOrgCode, bizOrgCode);
		lambda.eq(OrgUsr::getIsDelete, false);
		OrgUsr orgUsr = orgUsrMapper.selectList(lambda).get(0);
		if (!org.apache.commons.lang3.ObjectUtils.isEmpty(orgUsr.getBizOrgType()) && "COMPANY".equals(orgUsr.getBizOrgType())) {
			return ResponseHelper.buildResponse(orgUsr.getBizOrgCode());
		} else {
			return ResponseHelper.buildResponse(getCompanyNameById(orgUsr.getParentId()));
		}
	}
	private String getCompanyNameById(String id) {
		LambdaQueryWrapper<OrgUsr> lambda = new QueryWrapper<OrgUsr>().lambda();
		lambda.eq(OrgUsr::getSequenceNbr, id);
		lambda.eq(OrgUsr::getIsDelete, false);
		OrgUsr orgUsr = orgUsrMapper.selectList(lambda).get(0);
		if (!org.apache.commons.lang3.ObjectUtils.isEmpty(orgUsr.getBizOrgType()) && "COMPANY".equals(orgUsr.getBizOrgType())) {
			return orgUsr.getBizOrgCode();
		} else {
			return getCompanyNameById(orgUsr.getParentId());
		}

	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询单位基本信息", notes = "查询单位基本信息")
	@GetMapping(value = "/getCompanyInfo")
	public ResponseModel<Object> getCompanyInfo(@RequestParam String companyId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getByIduser(companyId));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "查询当前登陆人所属单位的下级部门", notes = "查询当前登陆人所属单位的下级部门")
	@PostMapping(value = "/getDetByCompanyId")
	public ResponseModel<Object> getDetByCompanyId() throws Exception {
		ResponseModel<String> parentId = this.getParentId();

		return ResponseHelper.buildResponse(iOrgUsrService.getDetByCompanyId(parentId.getResult()));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "查询单位基本信息", notes = "查询单位基本信息")
	@PostMapping(value = "/selectByIdDeptList")
	public ResponseModel<Object> selectByIdDeptList(@RequestBody String ids) throws Exception {

		String[] slid  =  ids.split(",");
		LambdaQueryWrapper<OrgUsr> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(OrgUsr::getIsDelete, false);
		wrapper.in(OrgUsr::getSequenceNbr, Arrays.asList(slid));
		List<OrgUsr> orgUsrList =orgUsrMapper.selectList(wrapper);
		return ResponseHelper.buildResponse(orgUsrList);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "查询单位基本信息", notes = "查询单位基本信息")
	@PostMapping(value = "/selectByAmosOrgIdDeptList")
	public ResponseModel<Object> selectByAmosOrgIdDeptList(@RequestBody String ids) throws Exception {

		String[] slid  =  ids.split(",");
		LambdaQueryWrapper<OrgUsr> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(OrgUsr::getIsDelete, false);
		wrapper.in(OrgUsr::getAmosOrgId, Arrays.asList(slid));
		List<OrgUsr> orgUsrList =orgUsrMapper.selectList(wrapper);
		return ResponseHelper.buildResponse(orgUsrList);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询单位基本信息", notes = "查询单位基本信息")
	@GetMapping(value = "/candidateGroupsUser")
	public Object selectByAmosOrgIdDeptList(@RequestParam(value="processDefinitionKey", required=false)  String processDefinitionKey,
														   @RequestParam(value="processDefinitionId", required=false)  String processDefinitionId,
														   @RequestParam("nodeKey") String nodeKey) throws Exception {
		JSONObject jsonObject = workflowFeignService.candidateGroupsUser(processDefinitionKey, processDefinitionId, nodeKey);
		String result = JSONObject.toJSONString(jsonObject.get("result"));
		List<Map> objects = JSONObject.parseArray(result,Map.class);
		objects.stream().forEach(e->{
			OrgUsr orgUsr = orgUsrMapper.queryByUserId(Long.valueOf(e.get("userId").toString()));
			if (!ObjectUtils.isEmpty(orgUsr)){
				e.put("realName",orgUsr.getBizOrgName());
			}
		});
		return ResponseHelper.buildResponse(objects) ;

	}


}