package com.yeejoin.equipmanage.config;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.equipmanage.fegin.JcsFeign;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.Map;

/**
 * @author DELL
 */
@Aspect
@Component
@ResponseBody
@Order(value = 1)
public class PersonIdentifyAspect {

    @Autowired
    RedisUtils redisUtils;
    @Autowired
    private JcsFeign jcsFeignClient;

    @Pointcut("execution(public * com.yeejoin.amos.*.business.controller..*(..))")
    public void userDate() {

    }


    @Before(value = "userDate()")
    public void personIdentity(JoinPoint joinPoint) {
        if(RequestContext.getToken() != null && RequestContext.getExeUserId() != null){
            ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);

            if (reginParam != null) {
                if (reginParam.getPersonIdentity() == null || reginParam.getPersonIdentity().getBizOrgCode() == null) {
                    String userId = reginParam.getUserModel().getUserId();
                    if (userId != null) {
                        FeignClientResult responseModel = jcsFeignClient.selectById(userId);
                        if (ObjectUtils.isEmpty(responseModel.getResult()) || responseModel.getStatus() != HttpStatus.OK.value()) {
                            throw new RuntimeException(responseModel.getDevMessage());
                        }
                        ReginParams.PersonIdentity personIdentity = (ReginParams.PersonIdentity) Bean.mapToBean((Map<String, Object>) responseModel.getResult(), ReginParams.PersonIdentity.class);
                        reginParam.setPersonIdentity(personIdentity);
                        redisUtils.set(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken()), JSONObject.toJSONString(reginParam));
                    }
                }
            }
        }



    }

}

