-- ----------------------------
-- View structure for v_today_alarm_confirm_jcs
-- ----------------------------
DROP VIEW IF EXISTS `v_today_alarm_confirm_jcs`;
CREATE ALGORITHM = UNDEFINED SQL SECURITY DEFINER VIEW `v_today_alarm_confirm_jcs` AS select (select count(1) from `wl_equipment_specific_alarm_log` `a` where (((to_days(`a`.`create_date`) - to_days(now())) = 0) and (`a`.`confirm_type` <> ''))) AS `have`,(select count(1) from `wl_equipment_specific_alarm_log` `a` where (((to_days(`a`.`create_date`) - to_days(now())) = 0) and isnull(`a`.`confirm_type`))) AS `wait`;
DROP VIEW IF EXISTS `v_equipment_num_fbwg_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_fbwg_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '92040300RJZ44'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000016'));
DROP VIEW IF EXISTS `v_equipment_num_fhz_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_fhz_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '92160200J4244'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000061'));
DROP VIEW IF EXISTS `v_equipment_num_gwdl_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_gwdl_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '92040700PEM44'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000016'));
DROP VIEW IF EXISTS `v_equipment_num_hwds_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_hwds_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '92040800CZU44'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000016'));
DROP VIEW IF EXISTS `v_equipment_num_kqcy_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_kqcy_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '920405002O544'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000016'));
DROP VIEW IF EXISTS `v_equipment_num_sdbja_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_sdbja_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '920404002PU44'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000016'));
DROP VIEW IF EXISTS `v_equipment_num_sgbjq_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_sgbjq_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '92041000LCW44'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000016'));
DROP VIEW IF EXISTS `v_equipment_num_xfzj_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_xfzj_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '92040900VUA44'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000016'));
DROP VIEW IF EXISTS `v_equipment_num_yjgb_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_yjgb_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '92120300CAA44'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000061'));
DROP VIEW IF EXISTS `v_equipment_num_ywtcq_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_num_ywtcq_jcs` AS select count(1) AS `total` from ((select `b`.`id` AS `id`,`b`.`system_id` AS `system_id` from (`wl_equipment_detail` `a` join `wl_equipment_specific` `b`) where ((`a`.`id` = `b`.`equipment_detail_id`) and (`b`.`system_id` <> '') and (`a`.`code` = '920402009EM44'))) `s` join `f_fire_fighting_system` `fs`) where (find_in_set(`fs`.`id`,`s`.`system_id`) and (`fs`.`code` = '029026401813010000000016'));
DROP VIEW IF EXISTS `v_water_sys_status_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_water_sys_status_jcs` AS
SELECT
	fs.`name` AS fightSysName,
	fs.`code` AS fightSysCode,
CASE

		WHEN IFNULL( COUNT( DISTINCT es.id ), 0 ) = 0 THEN
		'正常' ELSE '异常'
	END AS amount
FROM
	f_fire_fighting_system fs
	LEFT JOIN wl_equipment_specific es ON FIND_IN_SET( fs.id, es.system_id )
	LEFT JOIN wl_equipment_detail ed ON es.equipment_detail_id = ed.id
	LEFT JOIN wl_equipment_specific_alarm sa ON es.id = sa.equipment_specific_id
WHERE
	fs.`code` = '029026401813010000000047'
	AND UPPER( sa.equipment_specific_index_value ) = 'TRUE'
	AND ( ed.`code` LIKE '92010800%' OR ed.`code` LIKE '92010300%' OR ed.`code` LIKE '92010600%' );

DROP VIEW IF EXISTS `v_other_sys_status_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_other_sys_status_jcs` AS
SELECT
	fs.`name` AS fightSysName,
	fs.`code` AS fightSysCode,
CASE

		WHEN IFNULL( COUNT( DISTINCT es.id ), 0 ) = 0 THEN
		'正常' ELSE '异常'
	END AS amount
FROM
	f_fire_fighting_system fs
	LEFT JOIN wl_equipment_specific es ON FIND_IN_SET( fs.id, es.system_id )
	LEFT JOIN wl_equipment_detail ed ON es.equipment_detail_id = ed.id
	LEFT JOIN wl_equipment_specific_alarm sa ON es.id = sa.equipment_specific_id
WHERE
	fs.`code` = '029026401813010000000061'
	AND UPPER( sa.equipment_specific_index_value ) = 'TRUE';

DROP VIEW IF EXISTS `v_fire_sys_status_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_fire_sys_status_jcs` AS
SELECT
	fs.`name` AS fightSysName,
	fs.`code` AS fightSysCode,
CASE

		WHEN IFNULL( COUNT( DISTINCT es.id ), 0 ) = 0 THEN
		'正常' ELSE '异常'
	END AS amount
FROM
	f_fire_fighting_system fs
	LEFT JOIN wl_equipment_specific es ON FIND_IN_SET( fs.id, es.system_id )
	LEFT JOIN wl_equipment_detail ed ON es.equipment_detail_id = ed.id
	LEFT JOIN wl_equipment_specific_alarm sa ON es.id = sa.equipment_specific_id
WHERE
	fs.`code` = '029026401813010000000016'
	AND UPPER( sa.equipment_specific_index_value ) = 'TRUE'
	AND (
		ed.`code` LIKE '92040200%'
		OR ed.`code` LIKE '92041000%'
		OR ed.`code` LIKE '92040800%'
		OR ed.`code` LIKE '92040400%'
		OR ed.`code` LIKE '92040700%'
		OR ed.`code` LIKE '92160200%'
		OR ed.`code` LIKE '92040500%'
	OR ed.`code` LIKE '92041900%'
	);

DROP VIEW IF EXISTS `v_ecms_sys_status_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_ecms_sys_status_jcs` AS
SELECT
	fs.`name` AS fightSysName,
	fs.`code` AS fightSysCode,
CASE

		WHEN IFNULL( COUNT( DISTINCT es.id ), 0 ) = 0 THEN
		'正常' ELSE '异常'
	END AS amount
FROM
	f_fire_fighting_system fs
	LEFT JOIN wl_equipment_specific es ON FIND_IN_SET( fs.id, es.system_id )
	LEFT JOIN wl_equipment_detail ed ON es.equipment_detail_id = ed.id
	LEFT JOIN wl_equipment_specific_alarm sa ON es.id = sa.equipment_specific_id
WHERE
	fs.`code` = '029026401813010000000030'
	AND UPPER( sa.equipment_specific_index_value ) = 'TRUE'
	AND ( ed.`code` LIKE '92010800%' OR ed.`code` LIKE '92010300%' OR ed.`code` LIKE '92010600%' );

DROP VIEW IF EXISTS `v_fire_fas_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_fire_fas_jcs` AS select (select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920402009EM44') and (`wei`.`name_key` = 'FAS_SmokeAlarm_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `ywtcqpb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920402009EM44') and (`wei`.`name_key` = 'FAS_SmokeAlarm_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `ywtcqgz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920402009EM44') and (`wei`.`name_key` = 'FAS_SmokeAlarm_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `ywtcqhj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92041000LCW44') and (`wei`.`name_key` = 'FAS_SoundLightAlarm_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `sgbjqpb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92041000LCW44') and (`wei`.`name_key` = 'FAS_SoundLightAlarm_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `sgbjqgz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92041000LCW44') and (`wei`.`name_key` = 'FAS_SoundLightAlarm_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `sgbjqhj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040800CZU44') and (`wei`.`name_key` = 'FAS_InfraredLight_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `hwdspb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040800CZU44') and (`wei`.`name_key` = 'FAS_InfraredLight_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `hwdsgz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040800CZU44') and (`wei`.`name_key` = 'FAS_InfraredLight_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `hwdshj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920404002PU44') and (`wei`.`name_key` = 'FAS_ManualAlarm_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `sdbjapb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920404002PU44') and (`wei`.`name_key` = 'FAS_ManualAlarm_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `sdbjagz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920404002PU44') and (`wei`.`name_key` = 'FAS_ManualAlarm_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `sdbjahj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040700PEM44') and (`wei`.`name_key` = 'FAS_TemperatureCable_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `gwdlpb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040700PEM44') and (`wei`.`name_key` = 'FAS_TemperatureCable_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `gwdlgz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040700PEM44') and (`wei`.`name_key` = 'FAS_TemperatureCable_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `gwdlhj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000061') and (`wd`.`code` = '92160200J4244') and (`wei`.`name_key` = 'SCS_FireDamper_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `fhfpb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000061') and (`wd`.`code` = '92160200J4244') and (`wei`.`name_key` = 'SCS_FireDamper_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `fhfgz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000061') and (`wd`.`code` = '92160200J4244') and (`wei`.`name_key` = 'SCS_FireDamper_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `fhfhj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040300RJZ44') and (`wei`.`name_key` = 'FAS_TemperatureAlarm_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `fbwgpb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040300RJZ44') and (`wei`.`name_key` = 'FAS_TemperatureAlarm_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `fbwggz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040300RJZ44') and (`wei`.`name_key` = 'FAS_TemperatureAlarm_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `fbwghj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920405002O544') and (`wei`.`name_key` = 'FAS_AirSampler_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `kqcypb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920405002O544') and (`wei`.`name_key` = 'FAS_AirSampler_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `kqcygz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '920405002O544') and (`wei`.`name_key` = 'FAS_AirSampler_Alarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `kqcyhj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000061') and (`wd`.`code` = '92120300CAA44') and (`wei`.`name_key` = 'FAS_UltravioletLight_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `yjgbpb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000061') and (`wd`.`code` = '92120300CAA44') and (`wei`.`name_key` = 'FAS_UltravioletLight_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `yjgbgz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000061') and (`wd`.`code` = '92120300CAA44') and (`wei`.`name_key` = 'FAS_UltravioletLight_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `yjgbhj`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040900VUA44') and (`wei`.`name_key` = 'FAS_UltravioletLight_Shield') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `zwhypb`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040900VUA44') and (`wei`.`name_key` = 'FAS_UltravioletLight_Fault') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `zwhygz`,(select count(distinct `wes`.`id`) from ((((`wl_equipment_specific_index` `wesi` left join `wl_equipment_specific` `wes` on((`wes`.`id` = `wesi`.`equipment_specific_id`))) left join `wl_equipment_detail` `wd` on((`wd`.`id` = `wes`.`equipment_detail_id`))) left join `wl_equipment_index` `wei` on((`wei`.`id` = `wesi`.`equipment_index_id`))) left join `f_fire_fighting_system` `ffs` on(find_in_set(`ffs`.`id`,`wes`.`system_id`))) where ((`ffs`.`code` = '029026401813010000000016') and (`wd`.`code` = '92040900VUA44') and (`wei`.`name_key` = 'FAS_UltravioletLight_FireAlarm') and (upper(`wesi`.`value`) like '%TRUE%'))) AS `zwhyhj`;

DROP VIEW IF EXISTS `v_fire_monitor_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_fire_monitor_jcs` AS SELECT d.*
FROM (
SELECT
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44') AS dqhzjkqNum,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_FireAlarm' AND upper(wesi.value) like '%TRUE%') AS dqhzjkqhj,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Fault' AND upper(wesi.value) like '%TRUE%') AS dqhzjkqgz,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Shield' AND upper(wesi.value) like '%TRUE%') AS dqhzjkqpb,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44') AS gwtcqNum,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_FireAlarm' AND upper(wesi.value) like '%TRUE%') AS gwtcqhj,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Fault' AND upper(wesi.value) like '%TRUE%') AS gwtcqgz,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Shield' AND upper(wesi.value) like '%TRUE%') AS gwtcqpb,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44') AS sydltcqNum,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_FireAlarm' AND upper(wesi.value) like '%TRUE%') AS sydltcqhj,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Fault' AND upper(wesi.value) like '%TRUE%') AS sydltcqgz,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Shield' AND upper(wesi.value) like '%TRUE%') AS sydltcqpb,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44') AS dltcqNum,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_FireAlarm' AND upper(wesi.value) like '%TRUE%') AS dltcqhj,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Fault' AND upper(wesi.value) like '%TRUE%') AS dltcqgz,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Shield' AND upper(wesi.value) like '%TRUE%') AS dltcqpb,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44') AS dhtcqNum,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_FireAlarm' AND upper(wesi.value) like '%TRUE%') AS dhtcqhj,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Fault' AND upper(wesi.value) like '%TRUE%') AS dhtcqgz,
(SELECT
count(DISTINCT(wes.id))
FROM wl_equipment_specific_index wesi
LEFT JOIN wl_equipment_specific wes ON wes.id = wesi.equipment_specific_id
LEFT JOIN wl_equipment_index wei ON wei.id = wesi.equipment_index_id
LEFT JOIN f_fire_fighting_system ffs ON find_in_set(ffs.id, wes.system_id)
WHERE ffs.code = '029026401813010000000061' AND wes.code = '92120300CAA44' AND wei.name_key = 'FAS_UltravioletLight_Shield' AND upper(wesi.value) like '%TRUE%') AS dhtcqpb
) d ;

DROP VIEW IF EXISTS `v_person_onduty_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_person_onduty_jcs` AS SELECT team_name AS teamName, COUNT(id) AS num FROM wl_car WHERE team_id IS NOT NULL AND team_name IS NOT NULL GROUP BY team_id;

DROP VIEW IF EXISTS `v_equipment_firefighting_num_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_firefighting_num_jcs` AS
SELECT
	'个人防护装备' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '1%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7 UNION ALL
SELECT
	'消防车辆' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '2%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7 UNION ALL
SELECT
	'灭火器材装备' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '3%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7 UNION ALL
SELECT
	'灭火药剂' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '4%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7 UNION ALL
SELECT
	'抢险救援器材' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '5%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7 UNION ALL
SELECT
	'消防通信指挥装备' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '6%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7 UNION ALL
SELECT
	'特种消防装备' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '7%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7 UNION ALL
SELECT
	'防火检查与火灾调查装备' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '8%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7 UNION ALL
SELECT
	'其他类消防装备器材' AS `type`,
	count( `wes`.`id` ) AS `num`
FROM
	(
		(
			( `wl_equipment_specific` `wes` LEFT JOIN `wl_equipment_detail` `wed` ON ( ( `wed`.`id` = `wes`.`equipment_detail_id` ) ) )
			LEFT JOIN `wl_equipment` `we` ON ( ( `we`.`id` = `wed`.`equipment_id` ) )
		)
		LEFT JOIN `wl_equipment_category` `wec` ON ( ( `wec`.`id` = `we`.`category_id` ) )
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	)
WHERE
	( ( `wec`.`code` LIKE '9%' ) AND ( `wec`.`industry_code` = '2' ) )
	AND sd.`status` <> 7;

DROP VIEW IF EXISTS `v_equipment_extinguishing_num_jcs`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_equipment_extinguishing_num_jcs` AS
SELECT
CASE

	WHEN
		'41' = LEFT ( wec.`code`, 2 ) THEN
			'水灭火药剂'
			WHEN '42' = LEFT ( wec.`code`, 2 ) THEN
			'泡沫灭火剂'
			WHEN '43' = LEFT ( wec.`code`, 2 ) THEN
			'干粉灭火剂'
			WHEN '44' = LEFT ( wec.`code`, 2 ) THEN
			'气体灭火剂' ELSE '其他灭火剂'
		END AS `type`,
		count( DISTINCT `wes`.`id` ) AS `num`
	FROM
		`wl_equipment_specific` `wes`
		LEFT JOIN `wl_equipment_detail` `wed` ON `wed`.`id` = `wes`.`equipment_detail_id`
		LEFT JOIN `wl_equipment` `we` ON `we`.`id` = `wed`.`equipment_id`
		LEFT JOIN `wl_equipment_category` `wec` ON `wec`.`id` = `we`.`category_id`
		LEFT JOIN wl_stock_detail sd ON sd.equipment_specific_id = wes.id
	WHERE
		`wec`.`code` LIKE '4%'
		AND `wec`.`industry_code` = '2'
		AND sd.`status` <> 7
GROUP BY
	LEFT ( `wec`.`code`, 2 );

-- ----------------------------
-- View structure for v_fire_60list
-- ----------------------------
--DROP VIEW IF EXISTS `v_fire_60list`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `v_fire_60list` AS
SELECT
	sal.id AS `id`,
	`ec`.`code` AS `mRid`,
	`sal`.`equipment_specific_name` AS `specificName`,
	`sal`.`equipment_specific_index_key` AS `indexKey`,
	`sal`.`equipment_specific_index_name` AS `indexName`,
	`sal`.`equipment_specific_id` AS `specificId`,
	concat(sal.equipment_specific_name,sal.equipment_specific_index_name) as alamReason,
	`sal`.`iot_code` AS `iotCode`,
	date_format( `sal`.`create_date`, '%m-%d %H:%i:%s' ) AS `createDate`,
	(SELECT GROUP_CONCAT(id) FROM f_fire_fighting_system fs WHERE find_in_set( `fs`.`id`, `ec`.`system_id` )) AS `fightSysId`,
(SELECT GROUP_CONCAT(`code`) FROM f_fire_fighting_system fs WHERE find_in_set( `fs`.`id`, `ec`.`system_id` )) AS `fightSysMRid`,
(SELECT GROUP_CONCAT(`name`) FROM f_fire_fighting_system fs WHERE find_in_set( `fs`.`id`, `ec`.`system_id` ))  AS `fightSysName`
FROM
	wl_equipment_specific_alarm_log sal
	LEFT JOIN wl_equipment_specific_alarm sa ON sal.equipment_specific_alarm_id = sa.id
	LEFT JOIN `wl_equipment_specific` `ec` ON `sa`.`equipment_specific_id` = `ec`.`id`
ORDER BY
	`sal`.`create_date` DESC
	LIMIT 60;