package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 户用光伏监盘逆变器电能表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="JpInverterElectricityDto", description="户用光伏监盘逆变器电能表")
public class JpInverterElectricityDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "逆变器id")
    private Long inverterId;

    @ApiModelProperty(value = "sn编码")
    private String snCode;

    @ApiModelProperty(value = "电能名称")
    private String name;

    @ApiModelProperty(value = "电能类型(直流/交流)")
    private String type;

    @ApiModelProperty(value = "电压")
    private Double voltage;

    @ApiModelProperty(value = "电流")
    private Double current;

    @ApiModelProperty(value = "功率")
    private Double power;

    @ApiModelProperty(value = "频率")
    private Double frequency;

    @ApiModelProperty(value = "第三方电站id")
    private String thirdStationId;

    @ApiModelProperty(value = "第三方厂商标识")
    private String thirdCode;

}
