package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.hygf.api.dto.ToDoTasksPageDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.UserMessagePageDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.ToDoTasks;
import com.yeejoin.amos.boot.module.hygf.api.entity.UserMessage;
import com.yeejoin.amos.boot.module.hygf.api.mapper.UserMessageMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IUserMessageService;
import com.yeejoin.amos.boot.module.hygf.api.dto.UserMessageDto;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 人员消息服务实现类
 *
 * @author system_generator
 * @date 2023-09-12
 */
@Service
public class UserMessageServiceImpl extends BaseService<UserMessageDto,UserMessage,UserMessageMapper> implements IUserMessageService {

    @Autowired
    UserMessageMapper userMessageMapper;

    /**
     * 分页查询
     */
    public Page<UserMessageDto> queryForUserMessagePage(Page<UserMessageDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<UserMessageDto> queryForUserMessageList()   {
        return this.queryForList("" , false);
    }


    public IPage<UserMessage> queryUserMessagePageDto(UserMessagePageDto dto)   {

        //列表数据组装
        QueryWrapper<UserMessage> qw = new QueryWrapper<>();
        qw.eq(StringUtils.isNotEmpty(dto.getType()), "type",dto.getType() );
        qw.eq(StringUtils.isNotEmpty(dto.getAmosUserId()), "amos_user_id",dto.getAmosUserId() );
        qw.orderBy(Boolean.TRUE, Boolean.FALSE, "creation_time");
        IPage<UserMessage> toDoTasksPage = userMessageMapper.selectPage(dto, qw);
        return toDoTasksPage;
    }



}