package com.yeejoin.amos.boot.module.jxiop.biz.controller;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MonitorFanIndicator;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MonitorFanIndicatorMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IndicatorsDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.Test;
import com.yeejoin.amos.boot.module.jxiop.biz.scheduled.PowerGeneration;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationBasicServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.TestServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;
import java.util.concurrent.TimeUnit;


@RestController
@Api(tags = "Demo-test")
@RequestMapping(value = "/demo")
public class DemoController extends BaseController {
    Logger logger = LoggerFactory.getLogger(DemoController.class);

    @Autowired
    StationBasicServiceImpl stationBasicServiceimpl;
    @Autowired
    TestServiceImpl testServiceimpl;

    @Autowired
    InfluxDbConnection influxDbConnection;

    @Autowired
    InfluxDButils influxDButils;

    @Autowired
    EmqKeeper emqKeeper;

    @Autowired
    PowerGeneration powerGeneration;

    @Autowired
    private MonitorFanIndicatorMapper monitorFanIndicatorregionMapper;

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试prodcutcion 库")
    @GetMapping("/test")
    public StationBasic demoTest() {
        return stationBasicServiceimpl.getById(1660231556607774721L);
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试中间库")
    @GetMapping("/test1")
    public List<Test> demoTest1() {
        return testServiceimpl.getList();
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试influxdb")
    @GetMapping("/test3")
    public void demoTest2() {
        String sql = "SELECT * FROM indicators_1668801435891929089";
        String sql1 = "SELECT * FROM indicators_1668801570352926721";
        List<IndicatorsDto> list = influxDButils.getListData(sql, IndicatorsDto.class);
        List<IndicatorsDto> list2 = influxDButils.getListData(sql1, IndicatorsDto.class);
        System.out.println(list.size());
        System.out.println(list2.size());
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "初始化influxdb-风电、光伏、升压站")
    @GetMapping("/test4")
    public void demoTest3() {
        //数据说明 夏造风电、泰和光伏、夏造升压站、泰和升压站
        String [] strings = {"1668801435891929089","1669524885619085313"};
//        String [] strings = {"1669524885619085313"};
//        Object o=this.monitorFanIndicatorImpl.getIndicatoralueAvage("1668801435891929089","60秒平均风速");
//        System.out.println(o.toString());
        for (int i = 0; i < strings.length; i++) {
            QueryWrapper<MonitorFanIndicator> QueryWrapper = new QueryWrapper<>();
//        夏造风电
//        QueryWrapper.eq("gateway", "1668801435891929089");
//        泰和光伏
            QueryWrapper.eq("gateway", strings[i]);
            long DATE = new Date().getTime();
            System.out.println(DATE);
            List<MonitorFanIndicator> list = monitorFanIndicatorregionMapper.selectList(QueryWrapper);

            for (MonitorFanIndicator monitorFanIndicator : list) {
                Map<String, String> tag = new HashMap<>();
                Map<String, Object> maps2 = new HashMap<>();

                maps2.put("address", monitorFanIndicator.getIndexAddress());
                maps2.put("dataType", monitorFanIndicator.getDataType());
                maps2.put("equipmentSpecificName", monitorFanIndicator.getFanCode());
                tag.put("equipmentsIdx", monitorFanIndicator.getAddressGateway());
                maps2.put("gatewayId", monitorFanIndicator.getGateway());
                maps2.put("isAlarm", monitorFanIndicator.getIsAlarm());
                maps2.put("createdTime", "2023-07-05 18:30:26");
                maps2.put("unit", monitorFanIndicator.getUnit());
                maps2.put("value", "");
                maps2.put("valueLabel","" );
                maps2.put("traceId", "");
                maps2.put("equipmentIndexName", monitorFanIndicator.getIndicator());
                maps2.put("equipmentNumber", monitorFanIndicator.getEquipmentNumber());
                maps2.put("frontModule", monitorFanIndicator.getFrontModule());
                maps2.put("systemType", monitorFanIndicator.getSystemType());
                maps2.put("pictureName", monitorFanIndicator.getPictureName());
                //升压站的字段显示名称
                maps2.put("displayName", "");
                influxDbConnection.insert("indicators_" + monitorFanIndicator.getGateway(), tag, maps2, 1688558007051L, TimeUnit.MILLISECONDS);
            }
        }

    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "测试消息发送")
    @GetMapping("/test5")
    public void demoTest4() {
        HashMap<String, String> hashMap = new HashMap<>();
        hashMap.put("test", String.valueOf(Math.random() * 1000));
        hashMap.put("test1", String.valueOf(Math.random() * 100));
        try {
            emqKeeper.getMqttClient().publish("test_topic", JSON.toJSON(hashMap).toString().getBytes("UTF-8"), 1, true);
            emqKeeper.getMqttClient().publish("test_topic1", JSON.toJSON(hashMap).toString().getBytes("UTF-8"), 1, true);
            logger.info("++++++++++++++++++++++++++++++++++发送消息成功++++++++++++++++++++++++++++++++++++++");
        } catch (Exception exception) {
            logger.error("============================================================发送消息报错");
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "初始化升压站")
    @GetMapping("/test6")
    public void demoTest5() {
        //数据说明 夏造风电、泰和光伏、夏造升压站、泰和升压站
        String [] strings = {"1668801570352926721","1669525017559306241"};
//        String [] strings = {"1669525017559306241"};
//        Object o=this.monitorFanIndicatorImpl.getIndicatoralueAvage("1668801435891929089","60秒平均风速");
//        System.out.println(o.toString());
        for (int i = 0; i < strings.length; i++) {
            QueryWrapper<MonitorFanIndicator> QueryWrapper = new QueryWrapper<>();
//        夏造风电
//        QueryWrapper.eq("gateway", "1668801435891929089");
//        泰和光伏
            QueryWrapper.eq("gateway", strings[i]);
            long DATE = new Date().getTime();
            System.out.println(DATE);
            List<MonitorFanIndicator> list = monitorFanIndicatorregionMapper.selectList(QueryWrapper);

            for (MonitorFanIndicator monitorFanIndicator : list) {
                Map<String, String> tag = new HashMap<>();
                Map<String, Object> maps2 = new HashMap<>();

                maps2.put("address", monitorFanIndicator.getIndexAddress());
                maps2.put("dataType", monitorFanIndicator.getDataType());
                maps2.put("equipmentSpecificName", monitorFanIndicator.getFanCode());
                tag.put("equipmentsIdx", monitorFanIndicator.getAddressGateway());
                maps2.put("gatewayId", monitorFanIndicator.getGateway());
                maps2.put("isAlarm", monitorFanIndicator.getIsAlarm());
                maps2.put("createdTime", "2023-07-05 18:30:26");
                maps2.put("unit", monitorFanIndicator.getUnit());
                maps2.put("value", "");
                maps2.put("valueLabel","" );
                maps2.put("traceId", "");
                maps2.put("equipmentIndexName", monitorFanIndicator.getIndicator());
                maps2.put("equipmentNumber", monitorFanIndicator.getEquipmentNumber());
                maps2.put("frontModule", monitorFanIndicator.getFrontModule());
                maps2.put("systemType", monitorFanIndicator.getSystemType());
                maps2.put("pictureName", monitorFanIndicator.getPictureName());
                //升压站的字段显示名称
                maps2.put("displayName", monitorFanIndicator.getEquipmentNumber());
                influxDbConnection.insert("indicators_" + monitorFanIndicator.getGateway(), tag, maps2, 1688558007051L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "测试动态图片")
    @GetMapping("/test7")
    public ResponseModel<HashMap<String, String>> demoTest6() {
        HashMap<String, String> hashMap = new HashMap<>();
        hashMap.put("url", "upload/jxiop/amos_studio/758F6F4BC695B777899485DB0C7E5D3.gif");
        return ResponseHelper.buildResponse(hashMap);
    }



    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "test99")
    @GetMapping("/test99")
    public void test19() {
        powerGeneration.addESDailyPowerGeneration();
        powerGeneration.addESYearPowerGeneration();
        powerGeneration.addESMoonPowerGeneration();
    }

}
