package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MapRegion;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MapRegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.RegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.constants.CommonConstans;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.QueryDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SocialContributionDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.SjglZsjZsbtzMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.repository.ESEquipmentsRepository;
import com.yeejoin.amos.component.influxdb.InfluxdbUtil;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.*;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class CommonServiceImpl {

    @Autowired
    InfluxdbUtil influxdbUtil;
    @Autowired
    SjglZsjZsbtzMapper sjglZsjZsbtzMapper;
    @Autowired
    ESEquipmentsRepository equipmentsRepository;
    @Autowired
    private ElasticsearchRestTemplate elasticsearchTemplate;

    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private StationBasicMapper stationBasicMapper;

    @Resource
    private RegionMapper regionMapper;
    @Resource
    private MapRegionMapper mapRegionMapper;

    /**
     * 带参数 求平均值
     */
    public Double getavg(List<QueryDto> queryDto, String keyavg, Class clas) {
        Double value = null;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (QueryDto dto : queryDto) {
            queryBuilder.must(QueryBuilders.termQuery(dto.getKey(), dto.getValue()));
        }
        AvgAggregationBuilder buyCountAvg = AggregationBuilders.avg("buyCountAvg").field(keyavg);
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .addAggregation(buyCountAvg)
                .withPageable(PageRequest.of(0, 1))
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, clas);
        if (search.hasAggregations()) {
            Aggregations aggregations = search.getAggregations();
            if (Objects.nonNull(aggregations)) {
                Avg avg = aggregations.get("buyCountAvg");
                value = avg.getValue();
            }
        }
        return value;
    }

    /*

     *分组平均值
     **/
    public List<? extends Terms.Bucket> getgroupavg(Map<String, List<String>> value, String keyavg, String groupKey, Class clas) {
        List<? extends Terms.Bucket> listdata = null;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (String key : value.keySet()) {
            List<String> va = value.get(key);
            queryBuilder.must(QueryBuilders.termsQuery(key, va));
        }

        TermsAggregationBuilder tb1 = AggregationBuilders.terms("groupKey").field(groupKey);
        AvgAggregationBuilder buyCountAvg = AggregationBuilders.avg("buyCountAvg").field(keyavg);

        tb1.subAggregation(buyCountAvg);    // 通过typeId字段分组统计总数
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .addAggregation(tb1)
                .withPageable(PageRequest.of(0, 1))
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, ESEquipments.class);
        if (search.hasAggregations()) {
            Aggregations aggregations = search.getAggregations();
            if (Objects.nonNull(aggregations)) {
                List<Aggregation> list = aggregations.asList();
                listdata = list != null && !list.isEmpty() ? ((ParsedStringTerms) list.get(0)).getBuckets() : null;

            }
        }
        return listdata;
    }

    /*

     *分组求和
     **/
    public List<? extends Terms.Bucket> getgroupsum(Map<String, List<String>> value, String keyavg, String groupKey, Class clas) {
        List<? extends Terms.Bucket> listdata = null;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (String key : value.keySet()) {
            List<String> va = value.get(key);
            queryBuilder.must(QueryBuilders.termsQuery(key, va));
        }

        TermsAggregationBuilder tb1 = AggregationBuilders.terms("groupKey").field(groupKey);
        SumAggregationBuilder buyCountSum = AggregationBuilders.sum("buyCountSum").field(keyavg);
        tb1.subAggregation(buyCountSum);    // 通过typeId字段分组统计总数
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .addAggregation(tb1)
                .withPageable(PageRequest.of(0, 1))
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, ESEquipments.class);
        if (search.hasAggregations()) {
            Aggregations aggregations = search.getAggregations();
            if (Objects.nonNull(aggregations)) {
                List<Aggregation> list = aggregations.asList();
                listdata = list != null && !list.isEmpty() ? ((ParsedStringTerms) list.get(0)).getBuckets() : null;

            }
        }
        return listdata;
    }

    /**
     * 带参数 求和
     */
    public Double getsum(List<QueryDto> queryDto, String keysum, Class clas) {
        Double value = null;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (QueryDto dto : queryDto) {
            queryBuilder.must(QueryBuilders.termQuery(dto.getKey(), dto.getValue()));
        }
        SumAggregationBuilder buyCountSum = AggregationBuilders.sum("buyCountSum").field(keysum);
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .addAggregation(buyCountSum)
                .withPageable(PageRequest.of(0, 1))
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, clas);

        if (search.hasAggregations()) {
            Aggregations aggregations = search.getAggregations();
            if (Objects.nonNull(aggregations)) {
                Sum sum = aggregations.get("buyCountSum");
                value = sum.getValue();
            }
        }
        return value;
    }

    /**
     * @param queryDto
     * @param keysum
     * @param clas
     * @return
     * @deprecated 获取场站的设备总数
     */
    public Integer getCount(List<QueryDto> queryDto, String keysum, Class clas) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (QueryDto dto : queryDto) {
            queryBuilder.must(QueryBuilders.matchPhraseQuery(dto.getKey(), dto.getValue()));
        }
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .withPageable(PageRequest.of(0, 10000))
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, clas);
        return search.getSearchHits().size();
    }

    /**
     * @param gatewayId 网关id 用于拼接sql语句
     * @param indicator 指标名称  查询条件-根据指标名称获取风速
     * @return 指标值总和
     * @deprecated 获取指标值总和
     */
    public Double getTotalByIndicatior(String gatewayId, String indicator) {

        //用于组装-es查询条件
        Map<String, List<String>> queryCondtion = new HashMap<>();
        queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList(indicator));
        queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
        List<ESEquipments> result = getListDataByCondtions(queryCondtion, null, ESEquipments.class);
        Double totalvalue = 0.00;
        try {
            totalvalue = result.stream().filter(stringObjectMap -> !ObjectUtils.isEmpty(stringObjectMap.getValueF())).mapToDouble(l -> Double.parseDouble(l.getValueF().toString())).sum();
        } catch (Exception e) {
            return totalvalue;
        }
        return Double.valueOf(String.format("%.2f", totalvalue));
    }

    public Double getTotalByIndicatiorByGF(String gatewayId, String indicator) {

        //用于组装-es查询条件
        Map<String, List<String>> queryCondtion = new HashMap<>();
        Map<String, String> likeQuerCondtion = new HashMap<>();
        queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList(indicator));
        queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
        likeQuerCondtion.put(CommonConstans.QueryStringFrontMoudle, "逆变器");
        List<ESEquipments> result = getListDataByCondtions(queryCondtion, null, ESEquipments.class, likeQuerCondtion);
        Double totalvalue = 0.00;
        try {
            totalvalue = result.stream().filter(stringObjectMap -> !ObjectUtils.isEmpty(stringObjectMap.getValueF())).mapToDouble(l -> Double.parseDouble(l.getValueF().toString())).sum();
        } catch (Exception e) {
            return totalvalue;
        }
        if (indicator.equals("日发电量")) {
            return Double.valueOf(String.format("%.4f", totalvalue * CommonConstans.pvGenPoweActor * CommonConstans.pvGenPoweActorDay));
        }
        if (indicator.equals("年发电量")) {
            return Double.valueOf(String.format("%.4f", totalvalue * CommonConstans.pvGenPoweActorYear));
        }
        return Double.valueOf(String.format("%.4f", totalvalue * CommonConstans.pvGenPoweActor));
    }

    public Double getTotalByIndicatiorAndParams(String gatewayId, String indicator, String querySql) {
        String sql = "SELECT * FROM indicators_" + gatewayId + " where equipmentIndexName='" + indicator + "'";
        Double totalvalue = 0.00;
        try {
            if (null != querySql) {
                sql = sql + " " + querySql;
            }
            List<Map<String, Object>> mapList = influxdbUtil.query(sql);
            totalvalue = mapList.stream().filter(stringObjectMap -> !ObjectUtils.isEmpty(stringObjectMap.get("value"))).mapToDouble(l -> Double.parseDouble((String) l.get("value"))).sum();
        } catch (Exception e) {
            return totalvalue;
        }
        return Double.valueOf(String.format("%.2f", totalvalue));
    }

    public Double getNumByIndicatior(String gatewayId, String indicator) {
        String sql = "SELECT * FROM indicators_" + gatewayId + " where equipmentIndexName=~/" + indicator + "$/";
        Double totalvalue = 0.00;
        try {
            List<Map<String, Object>> mapList = influxdbUtil.query(sql);
            totalvalue = mapList.stream().filter(stringObjectMap -> !ObjectUtils.isEmpty(stringObjectMap.get("value"))).mapToDouble(l -> Double.parseDouble((String) l.get("value"))).sum();
        } catch (Exception e) {
            return totalvalue;
        }
        return Double.valueOf(String.format("%.2f", totalvalue));
    }

    /**
     * @param gatewayId 网关id 用于拼接sql语句
     * @param indicator 指标名称  查询条件-根据指标名称获取风速
     * @return 指标值总和
     * @deprecated 获取指标值平均值
     */
    public Double getAvgvalueByIndicatior(String gatewayId, String indicator) {
        String sql = "SELECT * FROM indicators_" + gatewayId + " where equipmentIndexName='" + indicator + "'";
        Double avageValue = 0.00;
        try {
            List<Map<String, Object>> mapList = influxdbUtil.query(sql);
            avageValue = mapList.stream().filter(stringObjectMap -> !ObjectUtils.isEmpty(stringObjectMap.get("value"))).mapToDouble(l -> Double.parseDouble((String) l.get("value"))).average().getAsDouble();
        } catch (Exception e) {
            return avageValue;
        }
        return Double.valueOf(String.format("%.2f", avageValue));
    }

    /**
     * @param mapList   查询出来的influxdb数据
     * @param indicator 指标名称
     * @return 该指标的求和数据
     */
    public Double getTotalByIndicatior(List<Map<String, Object>> mapList, String indicator) {
        Double totalvalue = 0.0000;
        try {
            totalvalue = mapList.stream().filter(stringObjectMap -> stringObjectMap.get("equipmentIndexName").toString().contains(indicator) && !ObjectUtils.isEmpty(stringObjectMap.get("value"))).mapToDouble(l -> Double.parseDouble((String) l.get("value"))).sum();
        } catch (Exception e) {
            return totalvalue;
        }
        return Double.valueOf(String.format("%.4f", totalvalue));
    }

    /**
     * @param indicator 指标名称  查询条件-根据指标名称获取风速
     * @return 指标值总和
     * @deprecated 获取指标值平均值
     */
    public Double getAvgvalueByIndicatior(List<Map<String, Object>> mapList, String indicator) {
        Double avageValue = 0.00;
        try {
            avageValue = mapList.stream().filter(stringObjectMap -> stringObjectMap.get("equipmentIndexName").toString().contains(indicator) && !ObjectUtils.isEmpty(stringObjectMap.get("value"))).mapToDouble(l -> Double.parseDouble((String) l.get("value"))).sum();
        } catch (Exception exception) {
            return avageValue;
        }
        return Double.valueOf(String.format("%.2f", avageValue));
    }

    /**
     * 根据场站Number获取装机容量
     *
     * @param WERKS
     * @return
     */
    public Double getStationCapactityByStationWerks(String WERKS) {
        return sjglZsjZsbtzMapper.getStationCapactityByStationWerks(WERKS);
    }

    /**
     * @param totalSocialContribution
     * @return
     * @deprecated 根据发电量获取社会贡献
     */

    public Page<SocialContributionDto> getSocialContributionDtoList(Double totalSocialContribution) {
        Page<SocialContributionDto> socialContributionDtoPage = new Page<SocialContributionDto>();
        List<SocialContributionDto> socialContributionDtoList = new ArrayList<>();

        //获取所有网关id不为空的数据

        //二氧化碳贡献数
        SocialContributionDto co2 = new SocialContributionDto();
        //标准煤贡献度
        SocialContributionDto coal = new SocialContributionDto();
        //碳粉尘计算公式
        SocialContributionDto toner = new SocialContributionDto();
        //二氧化硫贡献度
        SocialContributionDto so2 = new SocialContributionDto();
        /** 社会贡献原始计算公式，后边的数据已经经过处理
         发电量完成率=（月/年）发电量/（月/年）发电量指标
         小时数完成率=（月/年）可利用小时/（月/年）可利用小时数指标
         可利用小时(h)=（日/月/年）发电量（万kW·h）/装机容量（万kW）
         二氧化碳减排量（万t）=发电量（万kW·h）*0.79
         节约标准煤（万t）=发电量（万kW·h）*0.29
         炭粉尘减排量（t）=发电量（万kW·h）*0.30
         二氧化硫减排量（t）=发电量（万kW·h）*1.51
         氮氧化物减排量（t）=发电量（万kW·h）*1.69
         */
        co2.setUnit("二氧化碳减排量（万t）");
        co2.setTitle(String.format("%.2f", totalSocialContribution * CommonConstans.carbonDioxide));
        socialContributionDtoList.add(co2);
        coal.setUnit("节约标准煤（万t）");
        coal.setTitle(String.format("%.2f", (totalSocialContribution * CommonConstans.standardCoal)));
        socialContributionDtoList.add(coal);
        toner.setUnit("碳粉尘减排量（万t）");
        toner.setTitle(String.format("%.2f", (totalSocialContribution * CommonConstans.toner * CommonConstans.tToWT)));
        socialContributionDtoList.add(toner);
        so2.setUnit("二氧化硫减排量（万t）");
        so2.setTitle(String.format("%.2f", (totalSocialContribution * CommonConstans.sulfurDioxide * CommonConstans.tToWT)));
        socialContributionDtoList.add(so2);
        socialContributionDtoPage.setRecords(socialContributionDtoList);
        socialContributionDtoPage.setTotal(100);
        socialContributionDtoPage.setCurrent(1);
        return socialContributionDtoPage;
    }

    /**
     * @return 缓存的场站信息
     * @deprecated 获取缓存场站信息数据
     */
    public List<StationCacheInfoDto> getListStationCacheInfoDto() {
        List<StationCacheInfoDto> stationCacheInfoDtos = new ArrayList<>();
        List<Region> regionList = regionMapper.selectList(new QueryWrapper<Region>().eq("LEVEL", 1));
        List<MapRegion> mapRegionList = mapRegionMapper.selectList(new QueryWrapper<MapRegion>().isNotNull("name"));
        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("belong_area").isNotNull("fan_gateway_id"));
        for (int i = 0; i < stationBasicList.size(); i++) {
            StationBasic stationBasic = stationBasicList.get(i);
            StationCacheInfoDto stationCacheInfoDto = new StationCacheInfoDto();
            stationCacheInfoDto.setStationId(stationBasic.getSequenceNbr().toString());
            stationCacheInfoDto.setStationName(stationBasic.getStationName());
            stationCacheInfoDto.setStationType(stationBasic.getStationType());
            stationCacheInfoDto.setBelongProvince(regionList.stream().filter(region -> region.getRegionCode().toString().equals(stationBasic.getBelongArea().replace("[", "").split(",")[0])).map(region -> region.getRegionName()).collect(Collectors.toList()).get(0));
            stationCacheInfoDto.setBelongArea(mapRegionList.stream().filter(mapRegion -> mapRegion.getProvince().contains(stationCacheInfoDto.getBelongProvince().substring(0, 2)) || mapRegion.getProvince().contains(stationCacheInfoDto.getBelongProvince().substring(0, 3))).map(mapRegion -> mapRegion.getName()).collect(Collectors.toList()).get(0));
            stationCacheInfoDto.setInstalledCapacity(String.format("%.2f", sjglZsjZsbtzMapper.getStationCapactityByStationWerks(stationBasic.getStationNumber())));
            stationCacheInfoDto.setFanGatewayId(stationBasic.getFanGatewayId());
            stationCacheInfoDto.setAreaCode(mapRegionList.stream().filter(mapRegion -> mapRegion.getProvince().contains(stationCacheInfoDto.getBelongProvince().substring(0, 2)) || mapRegion.getProvince().contains(stationCacheInfoDto.getBelongProvince().substring(0, 3))).map(mapRegion -> mapRegion.getAreaCode()).collect(Collectors.toList()).get(0));
            stationCacheInfoDto.setBoosterGatewayId(stationBasic.getBoosterGatewayId());
            stationCacheInfoDtos.add(stationCacheInfoDto);
        }

        return stationCacheInfoDtos;
    }


    /**
     * @param stationId 场站id
     * @return 缓存的场站对象
     * @deprecated 根据场站id获取缓存数据中的场站对象
     */
    public StationCacheInfoDto getStationCacheInfoDtoByStationId(String stationId) {
        StationCacheInfoDto stationCacheInfoDto = this.getListStationCacheInfoDto().stream().filter(stationCacheInfoDto1 -> stationCacheInfoDto1.getStationId().equals(stationId)).collect(Collectors.toList()).get(0);
        return stationCacheInfoDto;
    }

    /**
     * @param stationid 场站id
     * @return 返回该场站的名称拼音缩写
     * @deprecated 根据场站id获取场站的首字母缩写
     */
    public String getFanDevicePrefix(String stationid) {
        StationBasic stationBasic = stationBasicMapper.selectById(stationid);
        return PinyinUtil.getFirstLetter(stationBasic.getStationName().split("风")[0], "").toUpperCase(Locale.ROOT);
    }

    /**
     * @param searchCondtionMap 需要查询的数据的 条件map
     * @return List<QueryDto>  QueryDtolist 用于给传值
     * @deprecated 将查询条件进行组装
     */
    public List<QueryDto> getQueryDtoList(Map<String, String> searchCondtionMap) {
        List<QueryDto> result = new ArrayList<>();
        searchCondtionMap.keySet().forEach(s -> {
            result.add(new QueryDto(s, searchCondtionMap.get(s)));
        });
        return result;
    }


    /**
     * 根据查询条件获取列表信息
     *
     * @param mustQuerCondtion
     * @param shouldQuerCondtion
     * @param tClass
     * @param <T>
     * @return
     */
    public <T> List<T> getListDataByCondtions(Map<String, List<String>> mustQuerCondtion, Map<String, String> shouldQuerCondtion, Class<T> tClass) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (!ObjectUtils.isEmpty(mustQuerCondtion)) {
            for (String key : mustQuerCondtion.keySet()) {
                List<String> va = mustQuerCondtion.get(key);
                queryBuilder.must(QueryBuilders.termsQuery(key, va));
            }
        }
        if (!ObjectUtils.isEmpty(shouldQuerCondtion)) {
            for (String key : shouldQuerCondtion.keySet()) {
                queryBuilder.should(QueryBuilders.wildcardQuery(key, shouldQuerCondtion.get(key)));
            }
        }
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, tClass);
        if (search.hasSearchHits()) {
            List<SearchHit<T>> searchHitList = search.getSearchHits();
            List<T> list = searchHitList.stream().map(hit -> hit.getContent()).collect(Collectors.toList());
            return list;
        }
        return null;
    }


    /**
     * 根据查询条件获取列表信息
     *
     * @param mustQuerCondtion
     * @param shouldQuerCondtion
     * @param tClass
     * @param <T>
     * @param likeMap            模糊字段查询 key：不能带.keyWords
     * @return
     */
    public <T> List<T> getListDataByCondtionsAndLike(Map<String, List<String>> mustQuerCondtion, Map<String, String> shouldQuerCondtion, Class<T> tClass, Map<String, String> likeMap) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (!ObjectUtils.isEmpty(mustQuerCondtion)) {
            for (String key : mustQuerCondtion.keySet()) {
                List<String> va = mustQuerCondtion.get(key);
                queryBuilder.must(QueryBuilders.termsQuery(key, va));
            }
        }
        if (!ObjectUtils.isEmpty(shouldQuerCondtion)) {
            for (String key : shouldQuerCondtion.keySet()) {
                queryBuilder.should(QueryBuilders.wildcardQuery(key, shouldQuerCondtion.get(key)));
            }
        }
        if (!ObjectUtils.isEmpty(likeMap)) {
            for (String key : likeMap.keySet()) {
                MatchPhraseQueryBuilder queryBuilder1 = QueryBuilders.matchPhraseQuery(key, "*" + likeMap.get(key) + "*");
                queryBuilder.must(queryBuilder1);
            }
        }

        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, tClass);
        if (search.hasSearchHits()) {
            List<SearchHit<T>> searchHitList = search.getSearchHits();
            List<T> list = searchHitList.stream().map(hit -> hit.getContent()).collect(Collectors.toList());
            return list;
        }
        return new ArrayList<>();
    }


    public <T> List<T> getListDataByCondtions(Map<String, List<String>> mustQuerCondtion, Map<String, String> shouldQuerCondtion, Map<String, String> notMustQuerCondtion, Class<T> tClass) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (!ObjectUtils.isEmpty(mustQuerCondtion)) {
            for (String key : mustQuerCondtion.keySet()) {
                List<String> va = mustQuerCondtion.get(key);
                queryBuilder.must(QueryBuilders.termsQuery(key, va));
            }
        }
        if (!ObjectUtils.isEmpty(shouldQuerCondtion)) {
            for (String key : shouldQuerCondtion.keySet()) {
                queryBuilder.should(QueryBuilders.wildcardQuery(key, shouldQuerCondtion.get(key)));
            }
        }
        if (!ObjectUtils.isEmpty(notMustQuerCondtion)) {
            for (String key : notMustQuerCondtion.keySet()) {
                queryBuilder.mustNot(QueryBuilders.termsQuery(key, notMustQuerCondtion.get(key)));
            }
        }

        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, tClass);
        if (search.hasSearchHits()) {
            List<SearchHit<T>> searchHitList = search.getSearchHits();
            List<T> list = searchHitList.stream().map(hit -> hit.getContent()).collect(Collectors.toList());
            return list;
        }
        return null;
    }

    public Double getAvagerByEquipmentIndxName(List<ESEquipments> equipments, String indexName) {
        Double result = 0.00;
        result = equipments.stream().filter(esEquipments -> esEquipments.getEquipmentIndexName().equals(indexName)).filter(esEquipments -> esEquipments.getValueF() != null).mapToDouble(ESEquipments::getValueF).average().getAsDouble();
        return result;
    }

    public Double getSumByEquipmentIndxName(List<ESEquipments> equipments, String indexName) {
        Double result = 0.00;
        result = equipments.stream().filter(esEquipments -> esEquipments.getEquipmentIndexName().equals(indexName)).filter(esEquipments -> esEquipments.getValueF() != null).mapToDouble(ESEquipments::getValueF).sum();
        return result;
    }

    public <T> List<T> getListDataByCondtions(Map<String, List<String>> mustQuerCondtion, Map<String, String> shouldQuerCondtion, Class<T> tClass, Map<String, String> likeQuerCondtion) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (!ObjectUtils.isEmpty(mustQuerCondtion)) {
            for (String key : mustQuerCondtion.keySet()) {
                List<String> va = mustQuerCondtion.get(key);
                queryBuilder.must(QueryBuilders.termsQuery(key, va));
            }
        }
        if (!ObjectUtils.isEmpty(shouldQuerCondtion)) {
            for (String key : shouldQuerCondtion.keySet()) {
                queryBuilder.should(QueryBuilders.wildcardQuery(key, shouldQuerCondtion.get(key)));
            }
        }

        if (!ObjectUtils.isEmpty(likeQuerCondtion)) {
            for (String key : likeQuerCondtion.keySet()) {
                queryBuilder.must(QueryBuilders.wildcardQuery(key, "*" + likeQuerCondtion.get(key) + "*"));
            }
        }
        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, tClass);
        if (search.hasSearchHits()) {
            List<SearchHit<T>> searchHitList = search.getSearchHits();
            List<T> list = searchHitList.stream().map(hit -> hit.getContent()).collect(Collectors.toList());
            return list;
        }
        return null;
    }


    public <T> List<T> getListDataByCondtionsByValueNotEqValueLabel(Map<String, List<String>> mustQuerCondtion, Map<String, String> shouldQuerCondtion, Map<String, String> notMustQuerCondtion, Class<T> tClass) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (!ObjectUtils.isEmpty(mustQuerCondtion)) {
            for (String key : mustQuerCondtion.keySet()) {
                List<String> va = mustQuerCondtion.get(key);
                queryBuilder.must(QueryBuilders.termsQuery(key, va));
            }
        }
        if (!ObjectUtils.isEmpty(shouldQuerCondtion)) {
            for (String key : shouldQuerCondtion.keySet()) {
                queryBuilder.should(QueryBuilders.wildcardQuery(key, shouldQuerCondtion.get(key)));
            }
        }
        if (!ObjectUtils.isEmpty(notMustQuerCondtion)) {
            for (String key : notMustQuerCondtion.keySet()) {
                queryBuilder.mustNot(QueryBuilders.termsQuery(key, notMustQuerCondtion.get(key)));
            }
        }

        Map<String, Object> params = new HashMap<>();
        params.put("param1", "");
        Script script = new Script(ScriptType.INLINE, Script.DEFAULT_SCRIPT_LANG,
                "doc['value.keyword'].value != doc['valueLabel.keyword'].value + params.param1", params);
        ScriptQueryBuilder scriptQueryBuilder = QueryBuilders.scriptQuery(script);
        queryBuilder.filter(scriptQueryBuilder);

        Query query = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .build();
        query.setTrackTotalHits(true);
        SearchHits search = elasticsearchTemplate.search(query, tClass);
        if (search.hasSearchHits()) {
            List<SearchHit<T>> searchHitList = search.getSearchHits();
            List<T> list = searchHitList.stream().map(hit -> hit.getContent()).collect(Collectors.toList());
            return list;
        }
        return null;
    }

}
