package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.netflix.discovery.converters.Auto;
import com.yeejoin.precontrol.common.entity.ProjectScore;
import com.yeejoin.precontrol.common.mapper.ProjectScoreMapper;
import com.yeejoin.precontrol.common.service.IProjectScoreService;
import com.yeejoin.precontrol.common.utils.DateUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 项目安全态势评分表 服务实现类
 *
 * @author duanwei
 * @date 2020-08-07
 */
@Service
public class ProjectScoreServiceImpl extends ServiceImpl<ProjectScoreMapper, ProjectScore> implements IProjectScoreService {

    @Autowired
    private ProjectScoreMapper projectScoreMapper;

    @Override
    public Integer allProjectAvgScore(String orgCode) {
        return projectScoreMapper.allProjectAvgScore(orgCode);
    }

    @Override
    public Integer getNowDateScore(Long projectId) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String day = dateFormat.format(new Date());
        String start = day + " 00:00:00";
        String end = day + " 23:59:59";
        ProjectScore projectScore = projectScoreMapper.selectOne(new LambdaQueryWrapper<ProjectScore>().eq(ProjectScore::getProjectId, projectId).between(ProjectScore::getCreateDate, start, end));
        if(projectScore != null){
            return projectScore.getScore().intValue();
        } else {
            // 查询该项目最后一次算分
            projectScore = projectScoreMapper.selectLastScoreByProjectId(projectId);
            if(projectScore != null){
                return projectScore.getScore().intValue();
            }
        }
        return 0;
    }
}
