package com.yeejoin.amos.boot.module.jg.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 单位变更登记
 *
 * @author system_generator
 * @date 2024-07-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgChangeVehicleRegistrationUnitDto", description = "单位变更登记")
public class JgChangeVehicleRegistrationUnitDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "变更类型（0区内，1区外）")
    private String changeType;

    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "申请日期")
    private Date applyDate;

    @ApiModelProperty(value = "登记机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "登记机构代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "登记机构公司代码")
    private String receiveCompanyCode;

    @ApiModelProperty(value = "终审通过时间")
    private Date auditPassDate;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date createDate;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "原使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "原使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "新使用单位统一信用代码")
    private String newUseUnitCreditCode;

    @ApiModelProperty(value = "新使用单位名称")
    private String newUseUnitName;

    @ApiModelProperty(value = "变更证明（买卖合同或其他变更使用单位证明）")
    private String changeCertificate;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecutorIds;

    @ApiModelProperty(value = "任务发起人id")
    private String promoter;

    @ApiModelProperty(value = "流程已执行记录角色id")
    private String instanceStatus;

    @ApiModelProperty(value = "办理状态")
    private String status;

    @ApiModelProperty(value = "设备使用登记注册编号")
    private String useRegistCode;

    @ApiModelProperty(value = "工作流下一节点任务id")
    private String nextTaskId;

    @ApiModelProperty(value = "下一节点执行人userIds")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "其他附件")
    private String otherAccessories;

    @ApiModelProperty(value = "接收单位org_code本来应该为receive_org_code但该字段被占用故同一此字段")
    private String receiveCompanyOrgCode;

    @ApiModelProperty(value = "经办人")
    private String agent;

    @ApiModelProperty(value = "经办人联系电话")
    private String agentPhone;

    @ApiModelProperty(value = "行驶证正面附件")
    private String driveLicenseFront;

    @ApiModelProperty(value = "行驶证背面附件")
    private String driveLicenseBack;

    @ApiModelProperty(value = "机动车登记证书附件")
    private String vehicleRegistrationCertificate;

    @ApiModelProperty(value = "属地监管部门code")
    private String orgBranchCode;

    @ApiModelProperty(value = "属地监管部门name")
    private String orgBranchName;

    @ApiModelProperty(value = "车辆属地")
    private String vehicleApanage;

    @ApiModelProperty(value = "车牌号")
    private String carNumber;

    @ApiModelProperty(value = "转办人")
    private String transferToUserIds;

    private List<String> roleIds;
}
