package com.yeejoin.amos.boot.module.statistics.api.mapper;

import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.biz.common.dto.KeyValueDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.statistics.api.dto.EquipQuestionNumCountDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface AQZSDPStatisticsMapper {

    String getOrgCodeByCompanyCode(@Param("cityCode") String cityCode);

    /**
     * 按照问题状态、问题类型分组统计问题数量
     * @param orgCode 区域对应orgCode
     * @param filterParamDto 过滤日期
     * @return List<CountDto>
     */
    List<CountDto> selectByOrgAndMainBody(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto);


    List<CountDto> selectByOrgAndProblemType(@Param("orgCode") String orgCode, @Param("enumNameList") List<String> enumNameList,
                                                        @Param("dto") DPFilterParamDto dpFilterParamDto, @Param("sourceTypeCode") String sourceTypeCode, @Param("equListCode") String equListCode);

    List<Map<String, Object>> getIssueCountByMonth(@Param("orgCode") String orgCode, @Param("year") String year, @Param("status") String status);

    List<Map<String, Object>> getIssueCountByDate(@Param("orgCode") String orgCode, @Param("year") String year, @Param("status") String status);

    int countByOrgCode(@Param("orgCode") String orgCode, @Param("now") String now);

    List<Map<String, String>> getOrgCodeAndCompanyCodesByCompanyCodes(@Param("regionCodes") List<Integer> regionCodes);

    List<Map<String, Object>> countByOrgCodes(@Param("orgCodes") List<String> orgCodes, @Param("now") String now);

    List<Map<String, Object>> issueMonthList(@Param("orgCode") String orgCode, @Param("time") String time);

    List<CountDto> issueProblemLevelCount(@Param("orgCode") String orgCode, @Param("time") String time);

    List<Map<String, Object>> issueCompanyTop(@Param("orgCode") String orgCode, @Param("time") String time);

    List<Map<String, Object>> issueChildrenCityCountTop(@Param("orgCodes") List<String> orgCodes, @Param("now") String now, @Param("status") String status);

    List<Map<String, Object>> issueCountTopByProblemType(@Param("orgCode") String orgCode, @Param("status") String status);

    List<EquipQuestionNumCountDto> queryEquipQuestionList(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);


    /**
     * 单位按照资质状态分组下的统计数量
     *
     * @param orgCode 区域
     * @return List<KeyValueDto>
     */
    List<KeyValueDto> queryLicenseEfficiencyOfRegion(@Param(value = "orgCode") String orgCode);
    /**
     * 查询单个单位的有效期信息
     *
     * @param appId 公司唯一标识
     * @return KeyValueDto
     */
    KeyValueDto queryLicenseEfficiencyOneCompany(@Param(value = "appId") String appId);

    Map<String, Object> getInspectionExpiredRate(@Param(value = "orgCode") String orgCode, @Param(value = "appId") String appId);

    Map<String, Object> getInspectionResultRate(@Param(value = "orgCode") String orgCode, @Param(value = "appId") String appId);

    List<Map<String, Object>> selectByOrg(String orgCode);

    List<Map<String, Object>> cylinderIssueMonthList(@Param("orgCode") String orgCode, @Param("time") String time);


    List<CountDto> selectByOrgAndProblemTypeForCy(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);
}
