package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.biz.common.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
/**
 * @description:
 * @author: tw
 * @createDate: 2023/4/24
 */

@Data
@ApiModel(value = "ExStationBasicDto", description = "")
public class ExStationBasicDto {
    @ExcelProperty(value = "场站名称", index = 0)
    @ApiModelProperty(value = "场站名称")
    private String stationName;
    @ExcelProperty(value = "场站编号", index = 1)
    @ApiModelProperty(value = "场站编号")
    private String stationCode;
    @ExplicitConstraint(indexNum = 2, source = {"建设方","总承包方","分包方"}) //固定下拉内容
    @ExcelProperty(value = "场站类型", index = 2)
    @ApiModelProperty(value = "场站类型")
    private String stationType;
    @ExplicitConstraint(indexNum = 3, source = {"开发","策划","在建","停建","完工","结算","尾款","关闭","终止","运维","测试"}) //固定下拉内容
    @ExcelProperty(value = "项目状态", index = 3)
    @ApiModelProperty(value = "项目状态")
    private String stationFlag;
    @ExcelProperty(value = "地址", index = 4)
    @ApiModelProperty("地址")
    private String address;
    @ExcelProperty(value = "站长", index = 5)
    @ApiModelProperty(value = "站长")
    private String stationMasterName;
    @ExcelProperty(value = "紧急联系方式（手机）", index = 6)
    @ApiModelProperty(value = "紧急联系方式（手机）")
    private String mobilePhone;
    @ExcelProperty(value = "电话", index = 7)
    @ApiModelProperty(value = "电话")
    private String phone;
    @ExcelProperty(value = "邮箱", index = 8)
    @ApiModelProperty(value = "邮箱")
    private String email;
    @ExcelProperty(value = "运维开始时间", index = 9)
    @ApiModelProperty(value = "运维开始时间")
    private String devopsTime;
    @ExcelProperty(value = "业主单位", index = 10)
    @ApiModelProperty(value = "业主单位")
    private String ownerUnit;
    @ExcelProperty(value = "简介", index = 11)
    @ApiModelProperty(value = "简介")
    private String briefIntroduction;
    @ExplicitConstraint(indexNum = 12, sourceClass = CommonExplicitConstraint.class, method = "getArea") //固定下拉内容
    @ExcelProperty(value = "所属片区", index = 12)
    @ApiModelProperty(value = "所属片区")
    private String area;

}
