package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.module.jxiop.api.entity.CommonFile;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/4/21
 */
@Data
public class PersonUser {

   /**
    * 基本信息
    * */
    @ApiModelProperty(value = "性别( 0-男 1-女 )")
    private String sex;

    @ApiModelProperty(value = "生日")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date birthday;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "籍贯")
    private String nativePlace;

    @ApiModelProperty(value = "民族")
    private String folkKey;

    @ApiModelProperty(value = "政治面貌")
    private String politicCountenance;

    @ApiModelProperty(value = "户籍地址")
    private String registeredResidenceAddress;

    @ApiModelProperty(value = "现住址")
    private String presentAddress;

    @ApiModelProperty(value = "应急电话")
    private String emergencyPhone;

    @ApiModelProperty(value = "电话")
    private String phone;

    @ApiModelProperty(value = "身高（厘米）")
    private Integer height;

    @ApiModelProperty(value = "体重（千克）")
    private Integer weight;

    @ApiModelProperty(value = "参加工作时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date workTime;

    @ApiModelProperty(value = "组织机构id")
    private String projectOrgCode;

    @ApiModelProperty(value = "人员头像")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> headPhoto;

    @ApiModelProperty(value = "证件照片正面")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> frontCertificatePhoto;

    @ApiModelProperty(value = "证件照片反面")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> backCertificatePhoto;

    /**
     * 技能学历
     * */

    @ApiModelProperty(value = "是否特殊工种")
    private String isSpecialWork;

    @ApiModelProperty(value = "技能鉴定工种key")
    private String workTypeKey;

    @ApiModelProperty(value = "工种名称")
    private String workName;


    @ApiModelProperty(value = "专业技术资格名称")
    private String professionalTechnologyName;

    @ApiModelProperty(value = "技能等级key")
    private String skillLevelKey;

    @ApiModelProperty(value = "专业技术资格等级")
    private String professionalTechnologyLevelKey;

    @ApiModelProperty(value = "岗位执业鉴定证书")
    private String professionalQualificationCertificate;

    @ApiModelProperty(value = " 岗位职业鉴定证书")
    private String professionalCareerCertificate;

    @ApiModelProperty(value = "初始学历key")
    private String initialEducationKey;

    @ApiModelProperty(value = "现学历key")
    private String currentEducationKey;

    @ApiModelProperty(value = "现学历学校名称")
    private String currentSchool;

    @ApiModelProperty(value = "现学历所学专业")
    private String currentMajor;
}
