package com.yeejoin.amos.boot.module.jxiop.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 人员技能和学历
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("person_skill_education")
public class PersonSkillEducation extends BaseEntity {

    private static final long serialVersionUID = 1L;



    /**
     * 人员信息id
     */
	@TableField("person_id")
    private Long personId;

    /**
     * 是否特殊工种
     */
	@TableField("is_special_work")
    private Integer isSpecialWork;

    /**
     * 工种名称
     * */
    @TableField("work_name")
    private String workName;



    /**
     * 技能鉴定工种key
     */
	@TableField("work_type_key")
    private String workTypeKey;

    /**
     * 技能等级key
     */
    @TableField("skill_level_key")
    private String skillLevelKey;


    /**
     * 专业技术资格名称
     */
	@TableField("professional_technology_name")
    private String professionalTechnologyName;



    /**
     * 专业技术资格等级
     */
	@TableField("professional_technology_level_key")
    private String professionalTechnologyLevelKey;



    /**
     * 初始学历key
     */
	@TableField("initial_education_key")
    private String initialEducationKey;

    /**
     * 现学历key
     */
	@TableField("current_education_key")
    private String currentEducationKey;

    /**
     * 现学历学校名称
     */
	@TableField("current_school")
    private String currentSchool;

    /**
     * 现学历所学专业
     */
	@TableField("current_major")
    private String currentMajor;



    /**
     * 岗位执业鉴定证书
     */
    @TableField("professional_qualification_certificate")
    private String professionalQualificationCertificate;

    /**
     * 岗位职业鉴定证书
     */
    @TableField("professional_career_certificate")
    private String professionalCareerCertificate;

}
