package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.dto.ListCompanyModel;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.UserOrgTreeModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/4/25
 */
@RestController
@Api(tags = "平台单位部门树")
@RequestMapping(value = "/companyClient")
public class PrivilegeController extends BaseController{
    @Autowired
    private RedisUtils redisUtils;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryOrgTree")
    @ApiOperation(httpMethod = "GET",value = "查询单位、子单位、部门树",  notes = "查询单位、子单位、部门树")
    public FeignClientResult<Collection<UserOrgTreeModel>> queryOrgTree() {
        //获取当前登录人单位
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);

        Long  companyId=reginParams.getCompany().getSequenceNbr();

        FeignClientResult<Collection<UserOrgTreeModel>> de =Privilege.companyClient.queryOrgTree(companyId);

     return de;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/subcompany")
    @ApiOperation(httpMethod = "GET",value = "查询单位、子单位",  notes = "查询单位、子单位")
    public ResponseModel< List<ListCompanyModel>> subcompany() {
        //获取当前登录人单位
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        Long  companyId=reginParams.getCompany().getSequenceNbr();
        List<ListCompanyModel >  date=new ArrayList();
        if("area".equals(reginParams.getCompany().getLevel())){
            ListCompanyModel companyModel=new ListCompanyModel();
            companyModel.setSequenceNbr(companyId);
            companyModel.setCompanyName(reginParams.getCompany().getCompanyName());
            date.add(companyModel);
        }else if("headquarter".equals(reginParams.getCompany().getLevel())){
            FeignClientResult<Collection<CompanyModel>> de =Privilege.companyClient.querySubAgencyTree(companyId);
            Collection<CompanyModel> dated= de.getResult();

            for (CompanyModel companyModel : dated) {
                if("area".equals(companyModel.getLevel())){
                    ListCompanyModel companyModeld=new ListCompanyModel();
                    companyModeld.setSequenceNbr(companyModel.getSequenceNbr());
                    companyModeld.setCompanyName(companyModel.getCompanyName());
                    date.add(companyModeld);
                }
            }
        }
        return ResponseHelper.buildResponse(date);
    }




}
