package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.excel.DataSources;
import com.yeejoin.amos.boot.biz.common.interceptors.PermissionInterceptorContext;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.dto.ListCompanyModel;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.UserOrgTreeModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/4/24
 */
@Service
public class ExDataSourcesImpl implements DataSources {

    @Autowired
    private RedisUtils redisUtils;


    @Override
    public String[] selectList(String type, String method) throws Exception {
        String[] str = {};
        if (StringUtils.isNotEmpty(type)) {
            str = getDataDictionary(type);
        } else {
            switch (method) {
                case "getArea":
                    str = getArea();
                    break;
            }
        }
        return str;
    }


    private String[] getArea() {


        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        Long  companyId=reginParams.getCompany().getSequenceNbr();
        List<ListCompanyModel >  date=new ArrayList();
        if("area".equals(reginParams.getCompany().getLevel())){
            ListCompanyModel companyModel=new ListCompanyModel();
            companyModel.setSequenceNbr(companyId);
            companyModel.setCompanyName(reginParams.getCompany().getCompanyName());
            date.add(companyModel);
        }else if("headquarter".equals(reginParams.getCompany().getLevel())){
            FeignClientResult<Collection<CompanyModel>> de =Privilege.companyClient.querySubAgencyTree(companyId);
            Collection<CompanyModel> dated= de.getResult();

            for (CompanyModel companyModel : dated) {
                if("area".equals(companyModel.getLevel())){
                    ListCompanyModel companyModeld=new ListCompanyModel();
                    companyModeld.setSequenceNbr(companyModel.getSequenceNbr());
                    companyModeld.setCompanyName(companyModel.getCompanyName());
                    date.add(companyModeld);
                }
            }
        }
        String[] str = null;
        List<String> collect=new ArrayList<>();
        this.getCompanyModel(date,collect);
        str = collect.toArray(new String[collect.size()]);

//        //获取当前登录人单位
//        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
//
//        Long  companyId=reginParams.getCompany().getSequenceNbr();
//
//        FeignClientResult<Collection<UserOrgTreeModel>> de =Privilege.companyClient.queryOrgTree(companyId);
//
//        Collection<UserOrgTreeModel> listco = new ArrayList<>();
//        String[] str = null;
//        if (!ObjectUtils.isEmpty(de)) {
//            if (de.getStatus() == 200) {
//                listco = de.getResult();
//                List<String> collect=new ArrayList<>();
//                this.getCompanyModel(listco,collect);
//                str = collect.toArray(new String[collect.size()]);
//            } else {
//                throw new RuntimeException(de.getMessage());
//            }
//        }
        return str;
    }



    public List<String> getCompanyModel( List<ListCompanyModel>  data,List<String> datas) {


        if (!data.isEmpty()) {
            for (ListCompanyModel datum : data) {
                datas.add(datum.getCompanyName() + "@" + datum.getSequenceNbr());
//                if (datum.getChildren() != null) {
//                    this.getCompanyModel(datum.getChildren(),datas);
//                }
            }

        }
    return datas;

    }




    private String[] getDataDictionary(String type) {
        List<String> collect =new ArrayList<>();
        String[] str = null;
         FeignClientResult<List<DictionarieValueModel>> de= Systemctl.dictionarieClient.dictValues(type);
        List<DictionarieValueModel> listco=new ArrayList<>();
        if (!ObjectUtils.isEmpty(de)) {
            if (de.getStatus() == 200) {
                listco = de.getResult();
                for (DictionarieValueModel dictionarieValueModel : listco) {
                    collect.add(dictionarieValueModel.getDictDataValue());
                }
                str = collect.toArray(new String[collect.size()]);

            } else {
                throw new RuntimeException(de.getMessage());
            }
        }
        return str;
    }



}
