package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.Enum.EquipType;
import com.yeejoin.amos.boot.module.jxiop.api.Enum.LevelType;
import com.yeejoin.amos.boot.module.jxiop.api.dto.*;
import com.yeejoin.amos.boot.module.jxiop.api.entity.*;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.HouseholdPvDistrictMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.HouseholdPvMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvContactService;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvInstallService;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvLeaseService;
import com.yeejoin.amos.boot.module.jxiop.api.service.IHouseholdPvService;
import com.yeejoin.amos.boot.module.jxiop.api.util.CommonResponse;
import com.yeejoin.amos.boot.module.jxiop.api.util.CommonResponseUtil;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.UserOrgTreeModel;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.LocalDateTime;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.ParseException;
import java.util.*;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 户用光伏表服务实现类
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Service
public class HouseholdPvServiceImpl extends BaseService<HouseholdPvDto, HouseholdPv, HouseholdPvMapper>
		implements IHouseholdPvService {

	@Autowired
	HouseholdPvMapper householdPvMapper;

	@Autowired
	IHouseholdPvContactService iHouseholdPvContactService;

	@Autowired
	IHouseholdPvLeaseService iHouseholdPvLeaseService;

	@Autowired
	IHouseholdPvInstallService iHouseholdPvInstallService;


	@Autowired
	HouseholdPvDistrictMapper householdPvDistrictMapper;

	@Autowired
	RedisUtils redisUtils;

	/**
	 * 身份证校验
	 */
	static final String ID_CARD =  "^[1-9]\\d{5}[1-9]\\d{3}((0[1-9])|(1[0-2]))(0[1-9]|([1|2][0-9])|3[0-1])((\\d{4})|\\d{3}X)$";
	/**
	 * 电话校验
	 */
	static final String PHONE =  "^1((3|4|5|6|7|8|9){1}\\d{1}|70)\\d{8}$";
	/**
	 * 分页查询
	 */
	public IPage<HouseholdPvDto> queryForHouseholdPvPage(Page<HouseholdPvDto> page, HouseholdPvDto dto) {
		String bizOrgCode = null;
		if (!ObjectUtils.isEmpty(dto.getPlatformCompanyId())) {
			bizOrgCode = getOrgCode(dto.getPlatformCompanyId());
			if (!ObjectUtils.isEmpty(bizOrgCode)) {
				dto.setBizOrgCode(bizOrgCode);
			}
		}
		Page<HouseholdPvDto> householdPvDtoPage = householdPvMapper.selectPageMessage(page, dto);
		Map<String, Object> map = companyList();
		householdPvDtoPage.getRecords().forEach(data -> {
			String commonFiles = householdPvMapper.selectImg(data.getSequenceNbr());
			if (!ObjectUtils.isEmpty(commonFiles)){
				List<CommonFile> filesList = JSON.parseArray(commonFiles, CommonFile.class);
				CommonFile commonFile = filesList.get(0);
				if (!ObjectUtils.isEmpty(commonFile)){
					data.setImg(ObjectUtils.isEmpty(commonFile.getUrl()) ? "" :commonFile.getUrl());
				}
			}
			data.setPlatformCompanyName(String.valueOf(map.get(data.getPlatformCompanyId().toString())));
		});
		return householdPvDtoPage;
	}

	private Map<String, Object> companyList() {
		HashMap<String, Object> map = new HashMap<>();
		ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
		Long sequenceNbr = reginParams.getCompany().getSequenceNbr();
		FeignClientResult<Collection<UserOrgTreeModel>> collectionFeignClientResult = Privilege.companyClient.queryOrgTree(sequenceNbr);
		List<CompanyTreeDto> list = householdPvDistrictMapper.getList();
		list.forEach(item -> {
			map.put(item.getId(), item.getName());
		});
		if (collectionFeignClientResult != null) {
			Collection<UserOrgTreeModel> result = collectionFeignClientResult.getResult();
			change(result, map);
		}
		return map;
	}

	private void change(Collection<UserOrgTreeModel> data, Map<String, Object> result) {
		data.forEach(item -> {
			result.put(item.getId(), item.getName());
			if (!ObjectUtils.isEmpty(item.getChildren())) {
				change(item.getChildren(), result);
			}
		});
	}

	/**
	 * 列表查询 示例
	 */
	public List<HouseholdPvDto> queryForHouseholdPvList() {
		return this.queryForList("", false);
	}


	private String checkData(List<HouseholdPvImport> list, Map<String, Object> map) {
		int line = 3;
		Map<String, Object> orgCodeMap = companyOrgCodeList();
		for (HouseholdPvImport dto : list) {
			if (ObjectUtils.isEmpty(dto.getPlatformCompanyId())) {
				return "第 " + line + " 行所属厂站不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getDistrictId())) {
				return "第 " + line + " 行乡镇不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getNumber())) {
				return "第 " + line + " 行户号不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getName())) {
				return "第 " + line + " 行户主名称不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getSex())) {
				return "第 " + line + " 行性别不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getIdNumber())) {
				return "第 " + line + " 行身份证号不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getExpiryTime())) {
				return "第 " + line + " 行证件过期时间不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getIssuingAuthority())) {
				return "第 " + line + " 行签发机关不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getResidenceAddress())) {
				return "第 " + line + " 行户籍地址不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getPhone())) {
				return "第 " + line + " 行行手机号码不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getAddress())) {
				return "第 " + line + " 行居住地不能为空！";
			}
			if (ObjectUtils.isEmpty(dto.getPostcode())) {
				return "第 " + line + " 行居住地邮编不能为空！";
			}
//			if (ObjectUtils.isEmpty(dto.getServiceAddress())) {
//				return "第 " + line + " 行送达地址不能为空！";
//			}
			// 导入文件中数据校验
			List<HouseholdPvImport> collect = list.stream().filter(item -> dto.getNumber().equals(item.getNumber())).collect(Collectors.toList());
			if (!ObjectUtils.isEmpty(collect) && collect.size() >= 2) {
				return "第" + line + " 行户号重复！";
			}
			// 户号已存在
			LambdaQueryWrapper<HouseholdPv> lambda = new QueryWrapper<HouseholdPv>().lambda();
			lambda.eq(HouseholdPv::getNumber, dto.getNumber());
			Integer integer = this.getBaseMapper().selectCount(lambda);
			if (integer > 0) {
				return "第" + line + " 行户号已存在！";
			}
			if (!map.containsKey(dto.getPlatformCompanyId())) {
				return "第" + line + " 行场站不存在！";
			}
			if (!map.containsKey(dto.getDistrictId())) {
				return "第" + line + " 行乡镇不存在！";
			}
			if (dto.getNumber().length() > 50) {
				return "第" + line + " 行户号最多输入50个字符！";
			}
			if (dto.getName().length() > 50) {
				return "第" + line + " 行户主姓名最多输入50个字符！";
			}
			boolean idCard = dto.getIdNumber().matches(ID_CARD);
			if (!idCard) {
				return "第" + line + " 行身份证号格式有误！";
			}
			if (dto.getIssuingAuthority().length() > 200) {
				return "第" + line + " 行签发机关最多输入200个字符！";
			}
			boolean phone = dto.getPhone().matches(PHONE);
			if (!phone) {
				return "第" + line + " 行手机号码格式有误！";
			}
			if (dto.getAddress().length() > 200) {
				return "第" + line + " 行居住地最多输入200个字符！";
			}
			if (dto.getPostcode().length() > 10) {
				return "第" + line + " 行居住地邮编最多输入10个字符！";
			}
//			if (dto.getServiceAddress().length() > 200) {
//				return "第" + line + " 行送达地址最多输入200个字符！";
//			}
			if (dto.getResidenceAddress().length() > 400) {
				return "第" + line + " 户籍地址最多输入400个字符！";
			}

			LambdaQueryWrapper<HouseholdPvDistrict> orgLambda = new QueryWrapper<HouseholdPvDistrict>().lambda();
			orgLambda.likeRight(HouseholdPvDistrict::getBizOrgCode, orgCodeMap.get(dto.getPlatformCompanyId()));
			List<HouseholdPvDistrict> householdPvDistricts = householdPvDistrictMapper.selectList(orgLambda);
			List<HouseholdPvDistrict> townshipList = householdPvDistricts.stream().filter(item -> dto.getDistrictId().equals(item.getName())).collect(Collectors.toList());
			if (ObjectUtils.isEmpty(townshipList)) {
				return "第" + line + " 行乡镇不属于该场站！";
			}
			line = line + 1;
		}

		return "ok";
	}

	@Override
	public CommonResponse importData(List<HouseholdPvImport> list) {
		ArrayList<HouseholdPv> householdPvs = new ArrayList<>();
		Map<String, Object> map = companyNameList();
		String checkData = checkData(list, map);
		if (!"ok".equals(checkData)){
			return CommonResponseUtil.failure(checkData);
		}
		list.forEach(item -> {
			HouseholdPv householdPv = new HouseholdPv();
			BeanUtils.copyProperties(item, householdPv, "platformCompanyId", "expiryTime" ,"districtId");
			// 默认状态为正常
			householdPv.setLevel(LevelType.NORMAL.getName());
			householdPv.setCreateTime(LocalDateTime.now().toDate());
			if (!ObjectUtils.isEmpty(item.getExpiryTime())) {
				try {
					Date date = DateUtils.dateParse(item.getExpiryTime(), DateUtils.DATE_PATTERN);
					householdPv.setExpiryTime(date);
				} catch (ParseException e) {
					e.printStackTrace();
				}
			}
			// 所属场站
			if (!ObjectUtils.isEmpty(item.getPlatformCompanyId())) {
				if (map.containsKey(item.getPlatformCompanyId())) {
					householdPv.setPlatformCompanyId(Long.parseLong(String.valueOf(map.get(item.getPlatformCompanyId()))));
				}
			}
			// 所属乡镇
			if (!ObjectUtils.isEmpty(item.getDistrictId())) {
				if (map.containsKey(item.getDistrictId())) {
					householdPv.setDistrictId(Long.parseLong(String.valueOf(map.get(item.getDistrictId()))));
					householdPv.setBizOrgCode(getOrgCode(householdPv.getDistrictId()));
				}
			}
			householdPvs.add(householdPv);
		});
		this.saveBatch(householdPvs);
		return CommonResponseUtil.success();
	}

	public Map<String, Object> companyNameList() {
		HashMap<String, Object> map = new HashMap<>();
		ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
		Long sequenceNbr = reginParams.getCompany().getSequenceNbr();
		FeignClientResult<Collection<UserOrgTreeModel>> collectionFeignClientResult = Privilege.companyClient.queryOrgTree(sequenceNbr);
		List<CompanyTreeDto> list = householdPvDistrictMapper.getList();
		list.forEach(item -> {
			map.put(item.getName(), item.getId());
		});
		if (collectionFeignClientResult != null) {
			Collection<UserOrgTreeModel> result = collectionFeignClientResult.getResult();
			changeName(result, map);
		}
		return map;
	}


	public Map<String, Object> companyOrgCodeList() {
		HashMap<String, Object> map = new HashMap<>();
		ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
		Long sequenceNbr = reginParams.getCompany().getSequenceNbr();
		FeignClientResult<Collection<UserOrgTreeModel>> collectionFeignClientResult = Privilege.companyClient.queryOrgTree(sequenceNbr);
		if (collectionFeignClientResult != null) {
			Collection<UserOrgTreeModel> result = collectionFeignClientResult.getResult();
			changeOrgCode(result, map);
		}
		return map;
	}

	private void changeOrgCode(Collection<UserOrgTreeModel> data, Map<String, Object> result) {
		data.forEach(item -> {
			result.put(item.getName(), item.getOrgCode());
			if (!ObjectUtils.isEmpty(item.getChildren())) {
				changeOrgCode(item.getChildren(), result);
			}
		});
	}
	private void changeName(Collection<UserOrgTreeModel> data, Map<String, Object> result) {
		data.forEach(item -> {
			result.put(item.getName(), item.getId());
			if (!ObjectUtils.isEmpty(item.getChildren())) {
				changeName(item.getChildren(), result);
			}
		});
	}

	@Override
	public List<HouseholdPvExport> selectExportList(HouseholdPvDto dto, List<Long> ids) {
		String bizOrgCode = null;
		if (!ObjectUtils.isEmpty(dto.getPlatformCompanyId())) {
			bizOrgCode = getOrgCode(dto.getPlatformCompanyId());
			if (!ObjectUtils.isEmpty(bizOrgCode)) {
				dto.setBizOrgCode(bizOrgCode);
			}
		}
		Map<String, Object> companyMap = companyList();
		List<HouseholdPvExport> householdPvExports = householdPvMapper.selectExportList(dto, ids);
		householdPvExports.forEach(item -> {
			// 所属场站
			if (!ObjectUtils.isEmpty(item.getPlatformCompanyId())) {
				if (companyMap.containsKey(item.getPlatformCompanyId())) {
					item.setPlatformCompanyId(companyMap.get(item.getPlatformCompanyId()).toString());
				} else {
					item.setPlatformCompanyId("");
				}
			}
			// 乡镇
			if (!ObjectUtils.isEmpty(item.getDistrictId())) {
				if (companyMap.containsKey(item.getDistrictId())) {
					item.setDistrictId(companyMap.get(item.getDistrictId()).toString());
				} else {
					item.setDistrictId("");
				}
			}
			// 安装信息-所属场站
			if (!ObjectUtils.isEmpty(item.getInstallStation())) {
				if (companyMap.containsKey(item.getInstallStation())) {
					item.setInstallStation(companyMap.get(item.getInstallStation()).toString());
				} else {
					item.setInstallStation("");
				}
			}
			if (!ObjectUtils.isEmpty(item.getPeriod())) {
				JSONArray objects = JSON.parseArray(item.getPeriod());
				if (!ObjectUtils.isEmpty(objects) && objects.size() >= 2) {
					item.setPeriod(objects.get(0) + "-" + objects.get(1));
				}
			}
			List<HouseholdPvDeviceDto> equipList = householdPvMapper.selectEquipList(item.getId());
			if (!ObjectUtils.isEmpty(equipList)) {
				StringBuilder stringBuilder = equipMessage(equipList);
				item.setEquipmentMessage(stringBuilder.toString());
			}
		});
		return householdPvExports;

	}

	private String getOrgCode(Long platformCompanyId) {
		String bizOrgCode = null;
		HouseholdPvDistrict parentDetail = householdPvDistrictMapper.selectById(platformCompanyId);
		if (ObjectUtils.isEmpty(parentDetail)) {
			FeignClientResult<CompanyModel> companyModelFeignClientResult = Privilege.companyClient.seleteOne(platformCompanyId);
			CompanyModel result = companyModelFeignClientResult.getResult();
			if (!ObjectUtils.isEmpty(result)) {
				bizOrgCode = result.getOrgCode();
			}
		} else {
			bizOrgCode = parentDetail.getBizOrgCode();
		}
		return bizOrgCode;
	}

	private StringBuilder equipMessage(List<HouseholdPvDeviceDto> list) {
		StringBuilder stringBuilder = new StringBuilder();
		list.forEach(item -> {
			stringBuilder.append("类型:").append(ObjectUtils.isEmpty(item.getType()) ? "" : item.getType());
			if (!ObjectUtils.isEmpty(item.getType()) && item.getType().equals(EquipType.OTHER.getName())) {
				stringBuilder.append(" 描述:").append(ObjectUtils.isEmpty(item.getDescription()) ? "" : item.getDescription());
			}else {
				stringBuilder.append(" 名称:").append(ObjectUtils.isEmpty(item.getName()) ? "" : item.getName());
				stringBuilder.append(" 品牌:").append(ObjectUtils.isEmpty(item.getBrand()) ? "" : item.getBrand());
				stringBuilder.append(" 型号:").append(ObjectUtils.isEmpty(item.getModel()) ? "" : item.getModel());
				stringBuilder.append(" SN编码:").append(ObjectUtils.isEmpty(item.getSNCode()) ? "" : item.getSNCode());
			}
			if (!ObjectUtils.isEmpty(item.getType()) && item.getType().equals(EquipType.INVERTER.getName())) {
				stringBuilder.append(" 序列号:").append(ObjectUtils.isEmpty(item.getSerialNumber()) ? "" : item.getSerialNumber());
				stringBuilder.append(" 功率:").append(ObjectUtils.isEmpty(item.getPower()) ? "" : item.getPower());
			}
			stringBuilder.append("\r\n");

		});
		return stringBuilder;
	}




	@Override
	public void deleteBatch(List<Long> ids) {
		householdPvMapper.deleteBatchIds(ids);
	}

	@Override
	public HouseholdPvDto save(HouseholdPvDto householdPvDto) {
		HouseholdPv householdPv = new HouseholdPv();
		BeanUtils.copyProperties(householdPvDto, householdPv);
		// 默认状态为正常
		householdPv.setLevel(LevelType.NORMAL.getName());
		householdPv.setBizOrgCode(getOrgCode(householdPv.getDistrictId()));
		this.save(householdPv);

		HouseholdPvContact householdPvContact = new HouseholdPvContact();
		BeanUtils.copyProperties(householdPvDto.getContactInfo(), householdPvContact);
		householdPvContact.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvContactService.save(householdPvContact);

		HouseholdPvLease householdPvLease = new HouseholdPvLease();
		BeanUtils.copyProperties(householdPvDto.getLeaseInfo(), householdPvLease);
		householdPvLease.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvLeaseService.save(householdPvLease);

		HouseholdPvInstall householdPvInstall = new HouseholdPvInstall();
		BeanUtils.copyProperties(householdPvDto.getInstallInfo(), householdPvInstall);
		householdPvInstall.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvInstallService.save(householdPvInstall);

		return householdPvDto;
	}

	@Override
	public HouseholdPvDto update(HouseholdPvDto householdPvDto) {
		HouseholdPv householdPv = new HouseholdPv();
		BeanUtils.copyProperties(householdPvDto, householdPv);
		householdPv.setBizOrgCode(getOrgCode(householdPv.getDistrictId()));
		this.updateById(householdPv);

		HouseholdPvContact householdPvContact = new HouseholdPvContact();
		BeanUtils.copyProperties(householdPvDto.getContactInfo(), householdPvContact);
		householdPvContact.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvContactService.saveOrUpdate(householdPvContact,new LambdaQueryWrapper<HouseholdPvContact>()
				.eq(HouseholdPvContact::getHouseholdPvId, householdPvDto.getSequenceNbr()));

		HouseholdPvLease householdPvLease = new HouseholdPvLease();
		BeanUtils.copyProperties(householdPvDto.getLeaseInfo(), householdPvLease);
		householdPvLease.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvLeaseService.saveOrUpdate(householdPvLease,new LambdaQueryWrapper<HouseholdPvLease>()
				.eq(HouseholdPvLease::getHouseholdPvId, householdPvDto.getSequenceNbr()));

		HouseholdPvInstall householdPvInstall = new HouseholdPvInstall();
		BeanUtils.copyProperties(householdPvDto.getInstallInfo(), householdPvInstall);
		householdPvInstall.setHouseholdPvId(householdPv.getSequenceNbr());
		iHouseholdPvInstallService.saveOrUpdate(householdPvInstall,new LambdaQueryWrapper<HouseholdPvInstall>()
				.eq(HouseholdPvInstall::getHouseholdPvId, householdPvDto.getSequenceNbr()));

		return householdPvDto;
	}

	@Override
	public Integer countRepeat(HouseholdPvDto householdPvDto, String type) {
		LambdaQueryWrapper<HouseholdPv> lambda = new QueryWrapper<HouseholdPv>().lambda();
		lambda.eq(HouseholdPv::getNumber, householdPvDto.getNumber());
		if ("upd".equals(type)){
			lambda.ne(HouseholdPv::getSequenceNbr, householdPvDto.getSequenceNbr());
		}
		return householdPvMapper.selectCount(lambda);
	}

	@Override
	public HouseholdPvDto getBySeq(Long id) {
		HouseholdPv householdPv = this.getById(id);
		HouseholdPvDto householdPvDto = new HouseholdPvDto();
		BeanUtils.copyProperties(householdPv, householdPvDto);

		HouseholdPvContact householdPvContact = iHouseholdPvContactService
				.getOne(new LambdaQueryWrapper<HouseholdPvContact>().eq(HouseholdPvContact::getHouseholdPvId, id));
		if (householdPvContact != null) {
			HouseholdPvContactDto householdPvContactDto = new HouseholdPvContactDto();
			BeanUtils.copyProperties(householdPvContact, householdPvContactDto);
			householdPvDto.setContactInfo(householdPvContactDto);
		}

		HouseholdPvLease householdPvLease = iHouseholdPvLeaseService
				.getOne(new LambdaQueryWrapper<HouseholdPvLease>().eq(HouseholdPvLease::getHouseholdPvId, id));
		if (householdPvLease != null) {
			HouseholdPvLeaseDto householdPvLeaseDto = new HouseholdPvLeaseDto();
			BeanUtils.copyProperties(householdPvLease, householdPvLeaseDto);
			householdPvDto.setLeaseInfo(householdPvLeaseDto);
		}

		HouseholdPvInstall householdPvInstall = iHouseholdPvInstallService
				.getOne(new LambdaQueryWrapper<HouseholdPvInstall>().eq(HouseholdPvInstall::getHouseholdPvId, id));
		if (householdPvInstall != null) {
			HouseholdPvInstallDto householdPvInstallDto = new HouseholdPvInstallDto();
			BeanUtils.copyProperties(householdPvInstall, householdPvInstallDto);
			householdPvDto.setInstallInfo(householdPvInstallDto);

		}

		return householdPvDto;
	}

	@Override
	public List<EquipMessageExport> selectExportEquipMessage(HouseholdPvDto dto, List<Long> ids) {
		String bizOrgCode = null;
		if (!ObjectUtils.isEmpty(dto.getPlatformCompanyId())) {
			bizOrgCode = getOrgCode(dto.getPlatformCompanyId());
			if (!ObjectUtils.isEmpty(bizOrgCode)) {
				dto.setBizOrgCode(bizOrgCode);
			}
		}
		return  householdPvMapper.selectExportEquipMessage(dto, ids);
	}


}