package com.yeejoin.amos.boot.module.tzs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquipmentCategoryEnum {

    /**
    **行政区划分及对应初始监管码
     */

    XZQHDT("行政区划电梯","XZQHDT"),
    XZQH("行政区划","XZQH"),
    BLW("补零位","0"),
    JGM("监管码初始码","0000001"),
    CSM("96333初始码","00001"),
    YJL("已拒领","6037"),
    YRL("已认领","6035"),
    DRL("待认领","6036"),
    CSZT("初始状态","0"),
    YSY("已使用","1"),
    WSY("未使用","2"),
    BF("报废","6");

    private String name;
    private String code;
    public static Map<String,String> getName=new HashMap<>();
    public static Map<String,String> getCode=new HashMap<>();
    static {
        for (EquipmentCategoryEnum e : EquipmentCategoryEnum.values()){
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }

    }
}
