package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsCitInfo;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.TzsAppService;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "tzs小程序接口")
@RequestMapping(value = "/tzs-app")
public class TzsAppController {

    @Autowired
    TzsAppService appService;

    /**
     * 获取设计信息
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentInfo")
    @ApiOperation(httpMethod = "GET", value = "获取设计信息", notes = "获取设计信息")
    public ResponseModel<Object> getEquipmentInfo(String record) {
        return ResponseHelper.buildResponse(appService.getEquipmentInfo(record));
    }
}
