package com.yeejoin.equipmanage.common.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 机构/部门/人员表
 *
 * @author tb
 * @date 2021-06-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OrgUsrDto", description = "机构/部门/人员表")
public class OrgUsrDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "唯一编号")
    private String code;

    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
    private String bizOrgType;

    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;

    @ApiModelProperty(value = "省市区code,用逗号分隔")
    private String pczCode;

    @ApiModelProperty(value = "省市区名称,用逗号分隔")
    private String pczName;

    @ApiModelProperty(value = "建筑ID")
    private String buildId;
}
