package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 锅炉
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_special_boiler")
public class SpecialBoiler extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 设备唯一编码
	 */
	@TableField("sequence_code")
	private String sequenceCode;
	/**
	 * 设计工作压力（MPa）
	 */
	@TableField("design_use_pressure")
	private String designUsePressure;
	/**
	 * 许可工作压力（MPa）
	 */
	@TableField("permit_use_pressure")
	private String permitUsePressure;
	/**
	 * 额定出力（t/h）
	 */
	@TableField("rated_output")
	private String ratedOutput;
	/**
	 * 介质出口温度（℃）
	 */
	@TableField("medium_outlet_temperature")
	private String mediumOutletTemperature;
	/**
	 * 加热方式
	 */
	@TableField("heating_mode")
	private String heatingMode;
	/**
	 * 燃料种类
	 */
	@TableField("fuel_type")
	private String fuelType;
	/**
	 * 锅炉用途
	 */
	@TableField("boiler_use")
	private String boilerUse;
	/**
	 * 燃烧方式
	 */
	@TableField("combustion_mode")
	private String combustionMode;
	/**
	 * 水处理方式
	 */
	@TableField("Water_handle_mode")
	private String waterHandleMode;
	/**
	 * 除氧方式
	 */
	@TableField("deaeration_mode")
	private String deaerationMode;
	/**
	 * 出渣方式
	 */
	@TableField("slagging_mode")
	private String slaggingMode;
	/**
	 * 消烟除尘方式
	 */
	@TableField("eliminationz_dust_mode")
	private String eliminationzDustMode;
	/**
	 * 单位司炉数量(人)
	 */
	@TableField("unit_stoker_num")
	private String unitStokerNum;
	/**
	 * 水质人员数量(人)
	 */
	@TableField("Water_quality_use_num")
	private String waterQualityUseNum;
	/**
	 * 最大连续蒸发量(t/h)
	 */
	@TableField("max_continuous_evaporation")
	private String maxContinuousEvaporation;
	/**
	 * 再热蒸汽流量(t/h)
	 */
	@TableField("reheat_steam_flow")
	private String reheatSteamFlow;
	/**
	 * 锅筒工作压力(MPa)
	 */
	@TableField("drum_working_pressure")
	private String drumWorkingPressure;
	/**
	 * 过热器出口压力(MPa)
	 */
	@TableField("superheater_outlet_pressure")
	private String superheaterOutletPressure;
	/**
	 * 再热器入口压力(MPa)
	 */
	@TableField("reheater_inlet_pressure")
	private String reheaterInletPressure;
	/**
	 * 再热器出口压力(MPa)
	 */
	@TableField("reheater_outlet_pressure")
	private String reheaterOutletPressure;
	/**
	 * 给水温度（℃）
	 */
	@TableField("water_temperature")
	private String waterTemperature;
	/**
	 * 过热器出口温度（℃）
	 */
	@TableField("superheater_outlet_temperature")
	private String superheaterOutletTemperature;
	/**
	 * 再热器入口温度（℃）
	 */
	@TableField("reheater_inlet_temperature")
	private String reheaterInletTemperature;
	/**
	 * 再热器出口温度（℃）
	 */
	@TableField("reheater_outlet_temperature")
	private String reheaterOutletTemperature;
	/**
	 * 直流锅炉启动压力（MPa）
	 */
	@TableField("direct_boiler_starting_pressure")
	private String directBoilerStartingPressure;
	/**
	 * 直流锅炉启动流量
	 */
	@TableField("direct_boiler_starting_flow")
	private String directBoilerStartingFlow;
	/**
	 * 水循环方式
	 */
	@TableField("water_circulation_mode")
	private String waterCirculationMode;
	/**
	 * 燃烧器布置方式
	 */
	@TableField("burner_layout_mode")
	private String burnerLayoutMode;
	/**
	 * 设计燃料可燃基挥发份
	 */
	@TableField("design_fuel_combustible_volatile")
	private String designFuelCombustibleVolatile;
	/**
	 * 设计应用基低位发热值
	 */
	@TableField("design_app_low_calorific_value")
	private String designAppLowCalorificValue;
	/**
	 * 设计应用基低位发热值单位
	 */
	@TableField("design_app_low_calorific_value_unit")
	private String designAppLowCalorificValueUnit;
	/**
	 * 补给水处理方式
	 */
	@TableField("water_supply_treatment_mode")
	private String waterSupplyTreatmentMode;
	/**
	 * 过热蒸汽调温方式
	 */
	@TableField("overheated_steam_temperature_regulation_mode")
	private String overheatedSteamTemperatureRegulationMode;
	/**
	 * 再热蒸汽调温方式
	 */
	@TableField("reheat_steam_temperature_regulation_mode")
	private String reheatSteamTemperatureRegulationMode;
	/**
	 * 锅炉汽水分离方式
	 */
	@TableField("boiler_soda_separate_mode")
	private String boilerSodaSeparateMode;
}
