package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
*
*
* @author system_generator
* @date 2021-06-29
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WaterResourcePoolDto", description="消防水池")
public class WaterResourcePoolDto  extends BaseDto {

   private static final long serialVersionUID = 1L;



    @ApiModelProperty(value = "资源id")
    private Long resourceId;

    @ApiModelProperty(value = "容积（m³）")
    private Float volume;

    @ApiModelProperty(value = "水源可用状态类别代码")
    private String statusCode;

    @ApiModelProperty(value = "水源可用状态类别名称")
    private String status;

    @ApiModelProperty(value = "所属路段")
    private String section;

    @ApiModelProperty(value = "取水方式")
    private String intakeForm;

    @ApiModelProperty(value = "取水高度(cm)")
    private Float intakeHeight;

    @ApiModelProperty(value = "水源标高差(cm)")
    private Float elevationDifference;

    @ApiModelProperty(value = "停车位置")
    private String parkingPosition;

    @ApiModelProperty(value = "停车数量(个)")
    private Integer parkingNum;

    @ApiModelProperty(value = "消防给水管网形式类型代码")
    private String pipeTypeCode;

    @ApiModelProperty(value = "消防给水管网形式类型名称")
    private String pipeTypeName;

    @ApiModelProperty(value = "供水单位名称")
    private String waterSupplyName;

    @ApiModelProperty(value = "更新人员")
    private String recUserName;

   @ApiModelProperty(value = "最低报警水位（m）")
   private Float minWaterLevel;

   @ApiModelProperty(value = "最高报警水位（m）")
   private Float maxWaterLevel;

   @ApiModelProperty("水池液位显示装置id")
   private String levelDeviceId;

   @ApiModelProperty("水池液位显示装置名称")
   private String levelDeviceName;

    @ApiModelProperty(value = "最高报警水位（m）")
    private Float outputFlowRate;
}
