package com.yeejoin.amos.boot.module.jczs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 投诉回访DTO
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DispatchConsultFeedbackDto", description="投诉回访DTO")
public class DispatchConsultFeedbackDto extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "投诉人")
    private String emergency;

    @ApiModelProperty(value = "投诉人电话")
    private String emergencyCall;

    @ApiModelProperty(value = "投诉反馈方式")
    private String consultFeedbackCode;

    @ApiModelProperty(value = "投诉反馈结果")
    private String feedbackResult;

    @ApiModelProperty(value = "投诉回访时间")
    private Date consultFeedbackTime;

    @ApiModelProperty(value = "投诉回访人")
    private String consultFeedbackUname;

    @ApiModelProperty(value = "投诉回访人Id")
    private String consultFeedbackUid;

    @ApiModelProperty(value = "响应人")
    private String responseUserName;

    @ApiModelProperty(value = "响应人电话")
    private String responseUserTel;

    @ApiModelProperty(value = "维修反馈方式Code")
    private String feedbackCode;

    @ApiModelProperty(value = "维修反馈方式")
    private String feedbackType;

    @ApiModelProperty(value = "处置结果")
    private String actionResult;

    @ApiModelProperty(value = "回访时间")
    private Date feedbackTime;

    @ApiModelProperty(value = "维保反馈人id")
    private String feedbackUid;

    @ApiModelProperty(value = "维保反馈人")
    private String feedbackUname;

    @ApiModelProperty(value = "电梯故障原因分类")
    private String errorResult;

    @ApiModelProperty(value = "备注")
    private String Remark;

    @ApiModelProperty(value = "维保反馈结果")
    private String mainFeedbackResult;

    @ApiModelProperty(value = "维保完成时间")
    private Date feedbackFinishTime;

    public DispatchConsultFeedbackDto() {

    }
}
