package com.yeejoin.amos.boot.module.statistcs.factory;

import com.yeejoin.amos.boot.module.common.api.enums.ZBGLEnum;
import com.yeejoin.amos.boot.module.statistcs.biz.service.IZBGLService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class ZBGLFactory implements ApplicationContextAware {
    @Autowired
    private static final Map<String, IZBGLService> strategyMap = new ConcurrentHashMap<>(16);
    public static IZBGLService getZBGL(String type) {
        return strategyMap.get(type);
    }
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        for(ZBGLEnum zbglEnum : ZBGLEnum.values()){
            if(!ValidationUtil.isEmpty(zbglEnum.getClassName())) {
                strategyMap.put(zbglEnum.getCode(), (IZBGLService) applicationContext.getBean(zbglEnum.getClassName()));
            }
        }
    }
}
