package com.yeejoin.amos.boot.module.hygf.api.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Vector;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/11/9
 */
public class UserEmpowerThreadLocal {
        private static final Logger logger = LoggerFactory.getLogger(com.yeejoin.amos.boot.biz.common.interceptors.PermissionInterceptorContext.class);

        private static ThreadLocal<UserEmpowerThreadLocalModel> requestContext = ThreadLocal.withInitial(UserEmpowerThreadLocalModel::new);

        private static UserEmpowerThreadLocalModel getPermissionInterceptorContext() {
            return requestContext.get();
        }

        public static List<String> getDataAuthRule() {
            return getPermissionInterceptorContext().getThreadLocalData();
        }

        public static void setDataAuthRule(List<String> dataAuthRule) {
            getPermissionInterceptorContext().setDataAuthRule(dataAuthRule);
        }

        public static void clean() {
            if (requestContext != null) {
                requestContext.remove();
            }
        }
    }