package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintainNoticeEqDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintainNoticeEqServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 维修告知设备关系表
 *
 * @author system_generator
 * @date 2023-12-18
 */
@RestController
@Api(tags = "维修告知设备关系表Api")
@RequestMapping(value = "/jg-maintain-notice-eq")
public class JgMaintainNoticeEqController extends BaseController {

    @Autowired
    JgMaintainNoticeEqServiceImpl jgMaintainNoticeEqServiceImpl;

    /**
     * 新增维修告知设备关系表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增维修告知设备关系表", notes = "新增维修告知设备关系表")
    public ResponseModel<JgMaintainNoticeEqDto> save(@RequestBody JgMaintainNoticeEqDto model) {
        model = jgMaintainNoticeEqServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新维修告知设备关系表", notes = "根据sequenceNbr更新维修告知设备关系表")
    public ResponseModel<JgMaintainNoticeEqDto> updateBySequenceNbrJgMaintainNoticeEq(@RequestBody JgMaintainNoticeEqDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(jgMaintainNoticeEqServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除维修告知设备关系表", notes = "根据sequenceNbr删除维修告知设备关系表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgMaintainNoticeEqServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个维修告知设备关系表", notes = "根据sequenceNbr查询单个维修告知设备关系表")
    public ResponseModel<JgMaintainNoticeEqDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgMaintainNoticeEqServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "维修告知设备关系表分页查询", notes = "维修告知设备关系表分页查询")
    public ResponseModel<Page<JgMaintainNoticeEqDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<JgMaintainNoticeEqDto> page = new Page<JgMaintainNoticeEqDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jgMaintainNoticeEqServiceImpl.queryForJgMaintainNoticeEqPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "维修告知设备关系表列表全部数据查询", notes = "维修告知设备关系表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<JgMaintainNoticeEqDto>> selectForList() {
        return ResponseHelper.buildResponse(jgMaintainNoticeEqServiceImpl.queryForJgMaintainNoticeEqList());
    }
}
