package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.strategy;

import com.yeejoin.amos.boot.module.jg.biz.reminder.core.ReminderFieldDiff;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderField;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
public class MaxGradeCalStrategy implements GradeCalculationStrategy {

    private final ReminderFieldDiff reminderFieldDiff;

    @Override
    public Integer calculateGrade(List<ReminderItemDto> equips, MatchItemDto matchItem) {
        List<ReminderItemDto> reminderItemList = reminderFieldDiff.getReminderItemList(equips, matchItem);
        List<ReminderField> items = reminderItemList.stream().flatMap(s -> s.getItems().stream()).collect(Collectors.toList());
        return items.stream().max(Comparator.comparingInt(ReminderField::getSId)).map(ReminderField::getSId).orElse(1);
    }

    @Override
    public String getStrategyType() {
        return "MAX_GRADE";
    }
}
