package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.bouncycastle.cms.PasswordRecipientId;

import java.math.BigDecimal;

/**
 * 注册登记信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_register_info")
public class RegistrationInfo extends AbstractEquipBaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     *  	 * $column.comments
     *      */


    /**
     * * $column.comments
     */

    @TableField(value = "\"INSTANCE_ID\"")
    private String instanceId;
    /**
     * * $column.comments
     */

    @TableField(value = "\"STATUS\"")
    private String status;
    /**
     * * 登记机关组织机构代码
     */

    @TableField(value = "\"ORGANIZATION_CODE\"")
    private String organizationCode;
    /**
     * * 登记机关名称
     */

    @TableField(value = "\"ORGANIZATION_NAME\"")
    private String organizationName;
    /**
     * * 使用登记证编号
     */

    @TableField(value = "\"USE_ORG_CODE\"")
    private String useOrgCode;
    /**
     * * 注册状态
     */

    @TableField(value = "\"REGISTER_STATE\"")
    private String registerState;


    /**
     * 设备代码类型手工输入（1）、系统自动生成（2）
     */
    @TableField("\"EQU_CODE_TYPE\"")
    private String equCodeType;
    /**
     * * 设备代码
     */

    @TableField(value = "\"EQU_CODE\"")
    private String equCode;
    /**
     * * 设备种类
     */

    @TableField(value = "\"EQU_LIST\"")
    private String equList;
    /**
     * * 设备类别
     */

    @TableField(value = "\"EQU_CATEGORY\"")
    private String equCategory;
    /**
     * * 设备品种
     */

    @TableField(value = "\"EQU_DEFINE\"")
    private String equDefine;
    /**
     * * 产品名称
     */

    @TableField(value = "\"PRODUCT_NAME\"")
    private String productName;
    /**
     * * 品牌名称
     */

    @TableField(value = "\"BRAND_NAME\"")
    private String brandName;
    /**
     * * 设备型号
     */

    @TableField(value = "\"EQU_TYPE\"")
    private String equType;
    /**
     * * 设备总价值（万元）
     */

    @TableField(value = "\"EQU_PRICE\"")
    private BigDecimal equPrice;
    /**
     * * 使用登记证
     */

    @TableField(value = "\"USE_REGISTRATION_CERTIFICATE\"")
    private String useRegistrationCertificate;
    /**
     * * 使用标志
     */

    @TableField(value = "\"USE_SIGN\"")
    private String useSign;
    /**
     * * 产品照片
     */

    @TableField(value = "\"PRODUCT_PHOTO\"")
    private String productPhoto;
    /**
     * * 车辆牌号
     */

    @TableField(value = "\"CAR_NUMBER\"")
    private String carNumber;
    /**
     * * 车架编号
     */

    @TableField(value = "\"FRAME_NUMBER\"")
    private String frameNumber;
    /**
     * * 发动机编号
     */

    @TableField(value = "\"ENGINE_NUMBER\"")
    private String engineNumber;
    /**
     * * 电动机编号
     */

    @TableField(value = "\"MOTOR_NUMBER\"")
    private String motorNumber;


    /**
     *
     */
    @TableField("\"OTHER_ACCESSORIES_REG\"")
    private String otherAccessoriesReg;

    /**
     * 是否车用气瓶（特种气瓶用于区分“内装填料气瓶、纤维缠绕气瓶、低温绝热气瓶”和车用气瓶）
     * 1：是
     * 0：不是
     */
    @TableField("\"WHETHER_VEHICLE_CYLINDER\"")
    private String whetherVehicleCylinder;


    /**
     * 最新使用登记证路径
     */

    @TableField("\"LAST_USE_CERT_FILE_PATH\"")
    private String lastUseCertFilePath;


    /**
     * 是否球罐
     *  1：是
     *  0：不是
     */
    @TableField("\"WHETHER_SPHERICAL_TANK\"")
    private String whetherSphericalTank;

}
