package com.yeejoin.amos.fas.dao.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;


/**
 * The persistent class for the fmea database table.
 */
@Entity
@Table(name = "f_fmea")
@NamedQuery(name = "Fmea.findAll", query = "SELECT f FROM Fmea f")
public class Fmea extends BasicEntity {
    private static final long serialVersionUID = 1L;

    @Column(name = "create_by")
    private String createBy;

    @Lob
    private String disposal;

    @Lob
    private String engineering;

    @Column(name = "evaluation_did")
    private Long evaluationDid;

    @Column(name = "evaluation_oid")
    private Long evaluationOid;

    @Column(name = "evaluation_sid")
    private Long evaluationSid;

    @Column(name = "new_evaluation_oid")
    private Long newEvaluationOid;

    @Column(name = "rpn")
    private BigDecimal rpn;

    private String didValue;

    private String oidValue;

    private String newOidValue;

    private String sidValue;

    @Lob
    private String management;

    @Lob
    private String protection;

    private String remark;

    @Column(name = "risk_factors_id")
    private Long riskFactorsId;

    @Column(name = "risk_source_id")
    private Long riskSourceId;

    @Column(name = "risk_level_id")
    private Long riskLevelId;

    private BigDecimal rpni;

    @Lob
    private String train;

    private RiskSource riskSource;

    @Column(name = "company_leader")
    private String companyLeader;

    @Column(name = "department_leader")
    private String departmentLeader;

    @Column(name = "group_leader")
    private String groupLeader;

    @Column(name = "person_leader")
    private String personLeader;

    @Column(name = "identify_user")
    private String identifyUser;

    @Column(name = "identify_method")
    private String identifyMethod;

    public Fmea() {
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getDisposal() {
        return this.disposal;
    }

    public void setDisposal(String disposal) {
        this.disposal = disposal;
    }

    public String getEngineering() {
        return this.engineering;
    }

    public void setEngineering(String engineering) {
        this.engineering = engineering;
    }

    public Long getEvaluationDid() {
        return this.evaluationDid;
    }

    public void setEvaluationDid(Long evaluationDid) {
        this.evaluationDid = evaluationDid;
    }

    public Long getEvaluationOid() {
        return this.evaluationOid;
    }

    public void setEvaluationOid(Long evaluationOid) {
        this.evaluationOid = evaluationOid;
    }

    public Long getEvaluationSid() {
        return this.evaluationSid;
    }

    public void setEvaluationSid(Long evaluationSid) {
        this.evaluationSid = evaluationSid;
    }

    public String getManagement() {
        return this.management;
    }

    public void setManagement(String management) {
        this.management = management;
    }

    public String getProtection() {
        return this.protection;
    }

    public void setProtection(String protection) {
        this.protection = protection;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getRiskFactorsId() {
        return this.riskFactorsId;
    }

    public void setRiskFactorsId(Long riskFactorsId) {
        this.riskFactorsId = riskFactorsId;
    }

    public Long getRiskSourceId() {
        return this.riskSourceId;
    }

    public void setRiskSourceId(Long riskSourceId) {
        this.riskSourceId = riskSourceId;
    }

    public BigDecimal getRpni() {
        return this.rpni;
    }

    public void setRpni(BigDecimal rpni) {
        this.rpni = rpni;
    }

    public String getTrain() {
        return this.train;
    }

    public void setTrain(String train) {
        this.train = train;
    }

    @ManyToOne
    @JoinColumn(name = "riskSourceId", referencedColumnName = "id", updatable = false, insertable = false)
    public RiskSource getRiskSource() {
        return riskSource;
    }

    @JsonBackReference
    public void setRiskSource(RiskSource riskSource) {
        this.riskSource = riskSource;
    }

    @Transient
    public String getDidValue() {
        return didValue;
    }

    public void setDidValue(String didValue) {
        this.didValue = didValue;
    }

    @Transient
    public String getOidValue() {
        return oidValue;
    }

    public void setOidValue(String oidValue) {
        this.oidValue = oidValue;
    }

    @Transient
    public String getNewOidValue() {
        return newOidValue;
    }

    public void setNewOidValue(String newOidValue) {
        this.newOidValue = newOidValue;
    }

    @Transient
    public String getSidValue() {
        return sidValue;
    }

    public void setSidValue(String sidValue) {
        this.sidValue = sidValue;
    }

    public Long getNewEvaluationOid() {
        return newEvaluationOid;
    }

    public void setNewEvaluationOid(Long newEvaluationOid) {
        this.newEvaluationOid = newEvaluationOid;
    }

    public BigDecimal getRpn() {
        return rpn;
    }

    public void setRpn(BigDecimal rpn) {
        this.rpn = rpn;
    }

    public String getCompanyLeader() {
        return companyLeader;
    }

    public void setCompanyLeader(String companyLeader) {
        this.companyLeader = companyLeader;
    }

    public String getDepartmentLeader() {
        return departmentLeader;
    }

    public void setDepartmentLeader(String departmentLeader) {
        this.departmentLeader = departmentLeader;
    }

    public String getGroupLeader() {
        return groupLeader;
    }

    public void setGroupLeader(String groupLeader) {
        this.groupLeader = groupLeader;
    }

    public String getPersonLeader() {
        return personLeader;
    }

    public void setPersonLeader(String personLeader) {
        this.personLeader = personLeader;
    }

    public String getIdentifyUser() {
        return identifyUser;
    }

    public void setIdentifyUser(String identifyUser) {
        this.identifyUser = identifyUser;
    }

    public String getIdentifyMethod() {
        return identifyMethod;
    }

    public void setIdentifyMethod(String identifyMethod) {
        this.identifyMethod = identifyMethod;
    }

    public Long getRiskLevelId() {
        return riskLevelId;
    }

    public void setRiskLevelId(Long riskLevelId) {
        this.riskLevelId = riskLevelId;
    }
}