package com.yeejoin.amos.knowledgebase.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocContentModel;
import com.yeejoin.amos.knowledgebase.face.service.DocContentService;
import com.yeejoin.amos.knowledgebase.face.service.DocLibraryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 文档库管理
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@RestController
@TycloudResource(module = "knowledgebase", value = "doclibrary")
@RequestMapping(value = "/v1/doccontent/outer")
@Api(tags = "knowledgebase-文档库对外接口")
public class DocOuterResource {

    @Autowired
    private DocLibraryService docLibraryService;
    @Autowired
    private DocContentService docContentService;

    /**
     * 分页列表展示
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分页查询文档信息")
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public ResponseModel<Page> queryDocPage(@RequestParam(value = "current") Integer current,
                                            @RequestParam(value = "size") Integer size,
                                            @RequestParam(value = "code", required = false) String code,
                                            @RequestParam(value = "docTitle", required = false) String docTitle,
                                            @RequestParam(value = "directoryId", required = false) Long directoryId,
                                            @RequestParam(value = "orgCode", required = false) String orgCode) {

        Page page = new Page(current, size);
        return ResponseHelper.buildResponse(docLibraryService.queryDocPage(page, docTitle, code,directoryId,orgCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询文档内容信息")
    @RequestMapping(value = "/{ids}", method = RequestMethod.GET)
    public ResponseModel<List<KnowledgeDocContentModel>> selectOne(@PathVariable("ids") String ids) {
        String[] idList = ids.split(",");
        List<KnowledgeDocContentModel> res = new ArrayList();
        for (String id : idList) {
            if (!ValidationUtil.isEmpty(id)) {
                res.add(docContentService.queryOneDocDetail(Long.parseLong(id.trim())));
            }
        }
        return ResponseHelper.buildResponse(res);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据分类查询随机N条已发布文档")
    @RequestMapping(value = "random-list", method = RequestMethod.GET)
    public ResponseModel<List<KnowledgeDocContentModel>> selectByDirsRand(
            @RequestParam(value = "directories") String directories,
            @RequestParam(value = "total",required = false) Integer total) {
        List<Long> directoryList;
        try {
            directoryList = StringUtil.String2LongList(directories);
        } catch (Exception e) {
            throw new BadRequest("参数有误");
        }
        if (ValidationUtil.isEmpty(total) || total==0) {
            total = null;
        }
        return ResponseHelper.buildResponse(docLibraryService.selectByDirsRand(directoryList, total));
    }

}

