package com.yeejoin.amos.boot.module.elevator.api.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDtoNew;
import com.yeejoin.amos.boot.module.elevator.api.entity.Elevator;
import com.yeejoin.amos.boot.module.elevator.api.entity.MaintenanceUnit;

import java.util.List;
import java.util.Map;

/**
*  服务类
*
* @author tb
* @date 2021-06-01
*/
public interface IElevatorService extends IService<Elevator> {
    /**
     * 根据警情返回电梯信息
     * @param alertId
     * @return
     */
    Map<String,Object> selectByAlertId(Long alertId);

    /**
     * 根据电梯id 生成电梯二维码
     * @param elevatorId
     * @return
     */
    String saveElevatorQrCode(Long elevatorId);

    List<ElevatorDto> selectExportData(String exportId);

    Map<String,Object> selectElevatorList(Elevator elevator);

    Page<Map<String, Object>> selectElevators(Page<Map<String, Object>>page, ElevatorDto dto);

    Page<JSONObject> queryByKeys(JSONObject map);

    List<ElevatorDtoNew> selectExportDataNew(ElevatorDto dto);

    List<Map<String, Object>> selectElevatorEsList(int pageNum,int pageSize);

    Integer selectUseInfoCount();

    List<Map<String,Object>> selectMtByAlertId(String sequenceNbr);

    Map<String, Object> selectUseUnitByAlertId(String sequenceNbr);
}
