package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertCalledFormDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.VoiceRecordFileDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.TzsCitInfo;
import com.yeejoin.amos.boot.module.elevator.api.entity.VoiceRecordFile;
import com.yeejoin.amos.boot.module.elevator.api.entity.VoiceRecordLog;
import com.yeejoin.amos.boot.module.elevator.api.mapper.VoiceRecordFileMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.ICtiService;
import com.yeejoin.amos.boot.module.elevator.api.service.IVoiceRecordFileService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;

/**
 * 通话记录附件服务实现类
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Service
public class VoiceRecordFileServiceImpl extends BaseService<VoiceRecordFileDto,VoiceRecordFile,VoiceRecordFileMapper> implements IVoiceRecordFileService {

    @Autowired
    private VoiceRecordFileServiceImpl voiceRecordFileServiceImpl;

    private final Logger logger = LogManager.getLogger(VoiceRecordFileServiceImpl.class);

    @Autowired
    AlertCalledServiceImpl iAlertCalledService;

    @Autowired
    ICtiService ctiService;

    private volatile JSONArray ctiInfos;

    @Autowired
    EmqKeeper emqKeeper;

    @Autowired
    VoiceRecordLogServiceImpl iVoiceRecordLogServiceImpl;

    @Autowired
    TzsCitInfoServiceImpl citInfoService;

    /**
     * 分页查询
     */
    public Page<VoiceRecordFileDto> queryForVoiceRecordFilePage(Page<VoiceRecordFileDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<VoiceRecordFileDto> queryForVoiceRecordFileList()   {
        return this.queryForList("" , false);
    }



    @Override
    public void publishRecord(final VoiceRecordFileDto model) {
            // 保存到日志表中
        VoiceRecordLog log = new VoiceRecordLog();
        log.setAlertId(model.getAlertId());
        log.setConnectId(model.getConnectId());
        log.setIsDeal(false);
        log.setDealTimes(0);
        iVoiceRecordLogServiceImpl.save(log);
    }

    @Override
    public Page<VoiceRecordFileDto> queryRecordListByQueryDto(Page<VoiceRecordFileDto> page, String telStartTimeStr, String telEndTimeStr, String fileType, String tel, String workNum, String sortParam, String sortRule, AgencyUserModel userModel) {
        //获取当前登陆人所在的技能组
        String groupCode = ctiService.getSkillGroup(userModel.getUserId());
        if (null == groupCode) {
            return new Page<>();
        }
        Page<List<VoiceRecordFileDto>>list = baseMapper.queryRecordListByQueryDto(page,
                telStartTimeStr,telEndTimeStr,fileType,tel,
                workNum,sortParam,sortRule,groupCode);
        Page<VoiceRecordFileDto> page1 = new Page<>();
        List<VoiceRecordFileDto> resultDtoList = JSONArray.parseArray(JSONArray.toJSONString(list.getRecords()),VoiceRecordFileDto.class);
        page1.setCurrent(page.getCurrent());
        page1.setSize(page.getSize());
        page1.setTotal(list.getTotal());
        page1.setRecords(resultDtoList);
        return page1;
    }

    @Override
    public VoiceRecordFileDto getRecordById(Long sequenceNbr) {
        VoiceRecordFileDto record = baseMapper.getRecordById(sequenceNbr);
        return record;
    }

    @Override
    public List<VoiceRecordFileDto> selectExportData(String exportId,AgencyUserModel userModel) {
        List<String> ids = null;
        if(StringUtils.isNotEmpty(exportId)) {
            String[] idStr = exportId.split(",");
            ids = Arrays.asList(idStr);
        }
        String groupCode = ctiService.getSkillGroup(userModel.getUserId());
        if (null == groupCode) {
            return new ArrayList<>();
        }
        return baseMapper.selectExportData(ids,groupCode);
    }
}