package com.yeejoin.amos.boot.module.cylinder.flc.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.api.entity.ESCylinderFillingRecordDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderFillingRecordDto;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderFillingRecord;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 液化气体气瓶充装信息-充装记录 Mapper 接口
 *
 * @author system_generator
 * @date 2022-03-04
 */
public interface CylinderFillingRecordMapper extends BaseMapper<CylinderFillingRecord> {

    Double queryIntegirtyByAppId(String appId);

    Double getFillingSum(@Param("regionCode") String r, @Param("time") Date time);

    /**
     * 根据查询条件返回充装记录信息
     * @param page
     * @param sortParam
     * @param sortRule
     * @return
     */
    Page<List<CylinderFillingRecordDto>> queryListByQueryDto(IPage<CylinderFillingRecordDto> page,
//                                                             @Param("fillingUnitName") String fillingUnitName,
//                                                             @Param("propertyUnit") String propertyUnit,
//                                                             @Param("factoryNum") String factoryNum,
//                                                             @Param("cylinderVariety") String cylinderVariety,
//                                                             @Param("qrCode") String qrCode,
//                                                             @Param("electronicLabelCode") String electronicLabelCode,
//                                                             @Param("sequenceCode") String sequenceCode,
//                                                             @Param("unitInnerCode") String unitInnerCode,
                                                             @Param("fillingStartTime") String fillingStartTime,
                                                             @Param("fillingEndTime") String fillingEndTime,
                                                             @Param("sortParam") String sortParam,
                                                             @Param("sortRule") String sortRule,
                                                             @Param("appId") String appId
    );


    List<ESCylinderFillingRecordDto> getCylinderFillingRecord();

    Double getFillingSumByMonth(@Param("appId") String appId, @Param("time") Date time);

    Integer getFillingCountByMonth(@Param("appId") String appId, @Param("time") Date time);

    Double getFillingSumByDate(@Param("appId") String appId, @Param("time") Date time);

    List<ESCylinderFillingRecordDto> getCylinderFillingRecordInfo(@Param("appIds") List<String> appIds,@Param("sequenceCodeS") List<String> sequenceCodeS);

    Integer getCylinderFillingRecordTotal();

    void updateCylinderFillingToEsStatus( @Param("ids")List<String> ids);
}
