package com.yeejoin.amos.boot.module.tcm.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.tcm.api.dto.GroupAndPersonInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsEquipListDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserQualifications;
import com.yeejoin.amos.feign.privilege.model.GroupModel;

import java.util.List;
import java.util.Map;

public interface ITzsUserInfoService extends IService<TzsUserInfo> {

    Page<TzsUserInfoDto> page(TzsUserInfoDto dto, Page<TzsUserInfoDto> page);

    void addQualificationsMessage(String userId, List<TzsUserQualifications> list);

    void  updateQualificationsMessage(String userId, List<TzsUserQualifications> list);

    void deleteBatch(Object[] ids);

    Map<String, Object> getDetail(Long id);

    boolean BindAccount(Map<String, Object> map);
    String startOrStopAccount(Map<String, Object> map);

    List<Map<String, Object>> getEquipmentType(String creditCode);

    List<Map<String, Object>> getUserType(String unitType);

    Map<String,Integer> getArrangementStatistic(String companyCode);

    Map<String,Object> getCompanyType();

    Page<TzsEquipListDto> getEquipList(String type,String userSeq,TzsEquipListDto dto, Page<TzsEquipListDto> page);

    Boolean equipBind(String type, String userSeq, String creditCode, Map<String,Object> map);

    List<TzsUserInfo> getSafetyList(String companyCode);

    List<Map<String,Object>>  getGroupList();

    Map<String,Object> getPersonType();

    List<GroupAndPersonInfoDto> getGroupAndPersonInfo(Long groupId);

    Boolean createUnitPerson();

//    void testGroup();
}
